/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/apikey"})
@Tag(name="99 Authentication")
public class ApiKeyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeyController.class);
    @Autowired
    private ApiKeyRegistry apiKeyRegistry;

    @Operation(summary="Check if API key is valid")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The API Key exists and is valid", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="401", description="The API Key does not exist or is invalid", content={@Content(schema=@Schema(hidden=true))})})
    @RequestMapping(method={RequestMethod.HEAD}, value={""})
    public ResponseEntity<?> todo(@RequestParam(value="api_key") String apiKey) {
        if (this.apiKeyRegistry.getApiKey(apiKey).isPresent()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }
}

