/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api;

import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class RequestContext {
    private final Logger logger = LoggerFactory.getLogger(RequestContext.class);
    private final boolean apiKeyProvided;
    private final Optional<ApiKey> apiKey;
    private boolean demoInstanceRequest;

    public RequestContext(HttpServletRequest httpServletRequest, ApiKeyRegistry apiKeyRegistry) {
        String apiKey;
        String serverName = httpServletRequest.getServerName();
        if (StringUtils.isNotBlank((CharSequence)serverName) && serverName.contains("demo.qr-invoice")) {
            this.demoInstanceRequest = true;
        }
        this.apiKeyProvided = (apiKey = httpServletRequest.getParameter("api_key")) != null && !apiKey.isEmpty();
        this.apiKey = apiKeyRegistry.getApiKey(apiKey);
    }

    public boolean isApiKeyProvided() {
        return this.apiKeyProvided;
    }

    public Optional<ApiKey> getApiKey() {
        return this.apiKey;
    }

    public boolean isDemoInstanceRequest() {
        return this.demoInstanceRequest;
    }

    public boolean isDemo() {
        try {
            ApiKey apiKey;
            if (this.apiKey.isPresent() && (apiKey = (ApiKey)this.apiKey.get()).isDemo()) {
                if (String.valueOf(apiKey.getCustomerId()).equals(MDC.get((String)"customerId"))) {
                    this.logger.debug("Demo API Key");
                    return true;
                }
                this.logger.warn("API Key resolved in RequestContext does not match the one given in MDC - API Key customerId={} vs MDC={}", (Object)apiKey.getCustomerId(), (Object)MDC.get((String)"customerId"));
                return false;
            }
            return this.demoInstanceRequest;
        }
        catch (Throwable t) {
            this.logger.warn("Error while check if demo mode should be enabled", t);
            return false;
        }
    }
}

