/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v1;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.PaymentPartReceiptController;
import ch.codeblock.qrinvoice.rest.api.v2.SwissPaymentsCodeController;
import ch.codeblock.qrinvoice.rest.api.v2.SwissQrCodeController;
import ch.codeblock.qrinvoice.rest.model.FontFamilyEnum;
import ch.codeblock.qrinvoice.rest.model.LanguageEnum;
import ch.codeblock.qrinvoice.rest.model.OutputResolutionEnum;
import ch.codeblock.qrinvoice.rest.model.PageSizeEnum;
import ch.codeblock.qrinvoice.rest.model.QrInvoice;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/qr-invoice"})
@Tag(name="XX Deprecated QR Invoice Operations v1")
public class QrInvoiceApiController {
    private final PaymentPartReceiptController paymentPartReceiptController;
    private final SwissQrCodeController swissQrCodeController;
    private final SwissPaymentsCodeController swissPaymentsCodeController;

    public QrInvoiceApiController(PaymentPartReceiptController paymentPartReceiptController, SwissQrCodeController swissQrCodeController, SwissPaymentsCodeController swissPaymentsCodeController) {
        this.paymentPartReceiptController = paymentPartReceiptController;
        this.swissQrCodeController = swissQrCodeController;
        this.swissPaymentsCodeController = swissPaymentsCodeController;
    }

    @Deprecated
    @Operation(summary="Create the Payment Part & Receipt from the given parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The payment part in the requested output format.", content={@Content(mediaType="application/pdf"), @Content(mediaType="image/png"), @Content(mediaType="image/gif"), @Content(mediaType="image/jpeg"), @Content(mediaType="image/bmp"), @Content(mediaType="image/tiff")})})
    @PostMapping(value={"/payment-part"}, consumes={"application/json"}, produces={"application/pdf", "image/png", "image/gif", "image/jpeg", "image/bmp", "image/tiff"})
    @ResponseBody
    public ResponseEntity<? extends Object> paymentPartReceipt(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Page Size") @RequestParam(value="pageSize", required=false, defaultValue="DIN_LANG") PageSizeEnum pageSize, @Parameter(description="Output Resolution") @RequestParam(value="resolution", required=false, defaultValue="MEDIUM_300_DPI") OutputResolutionEnum resolution, @Parameter(description="If a line should printed to mark the payment parts and receipts boundary") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If scissors should be printed on the boundary lines") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="true") Boolean boundaryLineSeparationText, @Parameter(description="QrInvoice") @RequestBody QrInvoice qrInvoiceRest) {
        return this.paymentPartReceiptController.createPaymentPartReceipt(accept, language, fontFamily, Boolean.valueOf(true), pageSize, resolution, boundaryLines, Boolean.valueOf(false), boundaryLineScissors, boundaryLineSeparationText, Boolean.valueOf(false), Boolean.valueOf(false), qrInvoiceRest);
    }

    @Deprecated
    @Operation(summary="Create the Swiss QR Code from the given parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The QR code in the requested output format.", content={@Content(mediaType="application/pdf"), @Content(mediaType="image/png"), @Content(mediaType="image/gif"), @Content(mediaType="image/jpeg"), @Content(mediaType="image/bmp"), @Content(mediaType="image/tiff")})})
    @PostMapping(value={"/swiss-qr-code"}, consumes={"application/json"}, produces={"application/pdf", "image/png", "image/gif", "image/jpeg", "image/bmp", "image/tiff"})
    @ResponseBody
    public ResponseEntity<? extends Object> swissQrCode(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Output Resolution") @RequestParam(value="resolution", required=false, defaultValue="MEDIUM_300_DPI") OutputResolutionEnum resolution, @Parameter(description="Desired QR Code size (in pixels)", example="500") @RequestParam(value="size", required=false) Integer qrCodeSize, @Parameter(description="QrInvoice", required=true, name="QrInvoice") @RequestBody QrInvoice qrInvoiceRest) {
        return this.swissQrCodeController.create(accept, resolution, qrCodeSize, Boolean.valueOf(false), qrInvoiceRest);
    }

    @Deprecated
    @Operation(summary="Create the Swiss Payments Code from the given parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The raw Swiss Payments Code (SPC)")})
    @PostMapping(value={"/swiss-payments-code"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> swissPaymentsCode(@RequestBody QrInvoice qrInvoiceRest) {
        return this.swissPaymentsCodeController.create(Boolean.valueOf(false), qrInvoiceRest);
    }
}

