/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.CountryController;
import ch.codeblock.qrinvoice.util.CountryUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/country"})
@Tag(name="23 Country Codes")
public class CountryController {
    private List<Country> countries;
    private List<String> countryCodes;

    @PostConstruct
    public void init() {
        ResourceBundle countriesBundle = CountryUtils.getCountries();
        ResourceBundle en = CountryUtils.getCountries((Locale)Locale.ENGLISH);
        ResourceBundle de = CountryUtils.getCountries((Locale)Locale.GERMAN);
        ResourceBundle fr = CountryUtils.getCountries((Locale)Locale.FRENCH);
        ResourceBundle it = CountryUtils.getCountries((Locale)Locale.ITALIAN);
        List countries = countriesBundle.keySet().stream().map(key -> new Country(key, en.getString((String)key), de.getString((String)key), fr.getString((String)key), it.getString((String)key))).sorted().collect(Collectors.toList());
        this.countryCodes = Collections.unmodifiableList(countries.stream().map(Country::getCode).collect(Collectors.toList()));
        this.moveElement(countries, "CH", 0);
        this.moveElement(countries, "LI", 1);
        this.moveElement(countries, "DE", 2);
        this.moveElement(countries, "AT", 3);
        this.moveElement(countries, "FR", 4);
        this.moveElement(countries, "IT", 5);
        this.countries = Collections.unmodifiableList(countries);
    }

    private void moveElement(List<Country> countries, String code, int targetIndex) {
        for (int i = 0; i < countries.size(); ++i) {
            if (!code.equals(countries.get(i).getCode())) continue;
            countries.add(targetIndex, countries.remove(i));
            return;
        }
    }

    @Operation(summary="List Countries")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of Countries according to ISO 3166-1 alpha-2")})
    @GetMapping(produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<Country>> list() {
        return ResponseEntity.ok((Object)this.countries);
    }

    @Operation(summary="List Country Codes")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of Country Codes according to ISO 3166-1 alpha-2")})
    @GetMapping(value={"codes"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<String>> listCodes() {
        return ResponseEntity.ok((Object)this.countryCodes);
    }

    @Operation(summary="Validate a Country Code against list of ISO 3166-1 alpha-2")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid Country Code", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="422", description="Invalid Country Code", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> validate(@Parameter(description="Country Code", schema=@Schema(example="CH")) @RequestBody String countryCode) {
        if (CountryUtils.isValidIsoCode((String)countryCode)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid Country Code. " + countryCode));
    }
}

