/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.BaseException;
import ch.codeblock.qrinvoice.MimeType;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.QrInvoiceDocumentScanner;
import ch.codeblock.qrinvoice.QrInvoicePaymentPartReceiptCreator;
import ch.codeblock.qrinvoice.bulk.QrInvoicePaymentPartReceiptBulkCreator;
import ch.codeblock.qrinvoice.model.ParseException;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.util.DemoValues;
import ch.codeblock.qrinvoice.model.validation.QrInvoiceValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.output.BulkOutput;
import ch.codeblock.qrinvoice.output.Output;
import ch.codeblock.qrinvoice.output.PaymentPartReceipt;
import ch.codeblock.qrinvoice.pdf.PdfMerger;
import ch.codeblock.qrinvoice.pdf.QrPdfMerger;
import ch.codeblock.qrinvoice.qrcode.DecodeException;
import ch.codeblock.qrinvoice.rest.api.RequestContext;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestParamHelper;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestResponseLogger;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.filter.ApiRequestLoggingFilter;
import ch.codeblock.qrinvoice.rest.model.FontFamilyEnum;
import ch.codeblock.qrinvoice.rest.model.InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.LanguageEnum;
import ch.codeblock.qrinvoice.rest.model.OutputResolutionEnum;
import ch.codeblock.qrinvoice.rest.model.PageSizeEnum;
import ch.codeblock.qrinvoice.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/payment-part-receipt"})
@Tag(name="11 Payment Part & Receipt (QR Bill)")
public class PaymentPartReceiptController {
    private final RequestContext requestContext;
    private final RequestResponseLogger requestResponseLogger;
    private final RequestParamHelper requestParamHelper;
    private final ResponseHelper responseHelper;

    public PaymentPartReceiptController(RequestContext requestContext, RequestResponseLogger requestResponseLogger, RequestParamHelper requestParamHelper, ResponseHelper responseHelper) {
        this.requestContext = requestContext;
        this.requestResponseLogger = requestResponseLogger;
        this.requestParamHelper = requestParamHelper;
        this.responseHelper = responseHelper;
    }

    @Operation(summary="Create Payment Part & Receipt")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The payment part & receipt in the requested output format.")})
    @PostMapping(value={""}, consumes={"application/json"}, produces={"application/pdf", "image/png", "image/gif", "image/jpeg", "image/bmp", "image/tiff"})
    @ResponseBody
    public ResponseEntity<?> createPaymentPartReceipt(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Embed Fonts in PDF") @RequestParam(value="fontsEmbedded", required=false, defaultValue="true") Boolean fontsEmbedded, @Parameter(description="Page Size") @RequestParam(value="pageSize", required=false, defaultValue="DIN_LANG") PageSizeEnum pageSize, @Parameter(description="Output Resolution") @RequestParam(value="resolution", required=false, defaultValue="MEDIUM_300_DPI") OutputResolutionEnum resolution, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoice") @RequestBody ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice) {
        Optional optionalOutputFormat = OutputFormat.getByMimeType((String)accept);
        if (!optionalOutputFormat.isPresent()) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        try {
            QrInvoice invoice = InboundModelMapper.create((boolean)normalizeInput).map(qrInvoice);
            PaymentPartReceipt paymentPartReceipt = this.getPaymentPartReceipt(language, fontFamily, fontsEmbedded, pageSize, resolution, boundaryLines, boundaryLinesMargins, boundaryLineScissors, boundaryLineSeparationText, additionalPrintMargin, invoice, (OutputFormat)optionalOutputFormat.get());
            return this.buildResponse(paymentPartReceipt);
        }
        catch (BaseException e) {
            return this.responseHelper.buildExceptionResponse((Exception)((Object)e));
        }
    }

    @Operation(summary="Create Payment Part & Receipt and merge it with a PDF")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The merged payment part as PDF.")})
    @PostMapping(value={"merge"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> createAndMergePaymentPartReceipt(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Embed Fonts in PDF") @RequestParam(value="fontsEmbedded", required=false, defaultValue="true") Boolean fontsEmbedded, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoice in JSON format") @RequestPart(value="QrInvoice") ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice, @Parameter(description="PDF file to be merged") @RequestPart(value="pdf") MultipartFile pdf, @Parameter(description="Page number on which to place the payment part receipt") @RequestParam(value="onPage", required=false, defaultValue="1") int onPage) {
        try {
            QrInvoice invoice = InboundModelMapper.create((boolean)normalizeInput).map(qrInvoice);
            PaymentPartReceipt paymentPartReceipt = this.getPaymentPartReceipt(language, fontFamily, fontsEmbedded, PageSizeEnum.A4, null, boundaryLines, boundaryLinesMargins, boundaryLineScissors, boundaryLineSeparationText, additionalPrintMargin, invoice, OutputFormat.PDF);
            byte[] mergedParts = QrPdfMerger.create().mergePdfs(pdf.getBytes(), paymentPartReceipt.getData(), onPage);
            PaymentPartReceipt mergedReceipt = new PaymentPartReceipt(paymentPartReceipt.getPageSize(), paymentPartReceipt.getOutputFormat(), mergedParts, paymentPartReceipt.getWidth(), paymentPartReceipt.getHeight());
            return this.buildResponse(mergedReceipt);
        }
        catch (BaseException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    @Operation(summary="Create Payment Part & Receipt and append it to a PDF on a new page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The PDF with the payment part & receipt appended.")})
    @PostMapping(value={"append"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> createAndAppendPaymentPartReceipt(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Embed Fonts in PDF") @RequestParam(value="fontsEmbedded", required=false, defaultValue="true") Boolean fontsEmbedded, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoice in JSON format") @RequestPart(value="QrInvoice") ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice, @Parameter(description="PDF file to be appended to") @RequestPart(value="pdf") MultipartFile pdf) {
        try {
            QrInvoice invoice = InboundModelMapper.create((boolean)normalizeInput).map(qrInvoice);
            PaymentPartReceipt paymentPartReceipt = this.getPaymentPartReceipt(language, fontFamily, fontsEmbedded, PageSizeEnum.A4, null, boundaryLines, boundaryLinesMargins, boundaryLineScissors, boundaryLineSeparationText, additionalPrintMargin, invoice, OutputFormat.PDF);
            byte[] mergedParts = QrPdfMerger.create().appendPdfs(Arrays.asList(pdf.getBytes(), paymentPartReceipt.getData()));
            PaymentPartReceipt mergedReceipt = new PaymentPartReceipt(paymentPartReceipt.getPageSize(), paymentPartReceipt.getOutputFormat(), mergedParts, paymentPartReceipt.getWidth(), paymentPartReceipt.getHeight());
            return this.buildResponse(mergedReceipt);
        }
        catch (BaseException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Clones / recreates a given Payment Part & Receipt based on an existing Swiss QR Code of a given document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The payment part & receipt in the requested output format.")})
    @PostMapping(value={"clone"}, consumes={"multipart/form-data"}, produces={"application/pdf", "image/png", "image/gif", "image/jpeg", "image/bmp", "image/tiff"})
    @ResponseBody
    public ResponseEntity<?> createAndAppendPaymentPartReceipt(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Embed Fonts in PDF") @RequestParam(value="fontsEmbedded", required=false, defaultValue="true") Boolean fontsEmbedded, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, last page is expected to contain only the Swiss QR Code and should be replaced with the newly generated payment part & receipt. Only works for PDF") @RequestParam(value="replaceLastPage", required=false, defaultValue="false") Boolean replaceLastPage, @Parameter(description="Document to clone the payment part & receipt from") @RequestPart(value="file") MultipartFile file) {
        Optional optionalOutputFormat = OutputFormat.getByMimeType((String)accept);
        if (!optionalOutputFormat.isPresent()) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        Optional documentScannerOptional = this.determineMimeType(file).flatMap(arg_0 -> this.getDocumentScanner(arg_0));
        if (!documentScannerOptional.isPresent()) {
            return this.responseHelper.inputMimeTypeNotSupported(file);
        }
        QrInvoiceDocumentScanner documentScanner = (QrInvoiceDocumentScanner)documentScannerOptional.get();
        try (InputStream documentInputStream = file.getInputStream();){
            Optional qrInvoiceOptional = documentScanner.scanDocumentUntilFirstSwissQrCode(documentInputStream);
            if (qrInvoiceOptional.isPresent()) {
                int lastDotIndex;
                String filename;
                QrInvoice qrInvoice = (QrInvoice)qrInvoiceOptional.get();
                QrInvoiceValidator.create().validate(qrInvoice).throwExceptionOnErrors();
                PaymentPartReceipt paymentPartReceipt = this.getPaymentPartReceipt(language, fontFamily, fontsEmbedded, PageSizeEnum.A4, null, boundaryLines, boundaryLinesMargins, boundaryLineScissors, boundaryLineSeparationText, additionalPrintMargin, qrInvoice, (OutputFormat)optionalOutputFormat.get());
                String baseFilename = this.getOriginalBaseFilename(file);
                String string = filename = StringUtils.isNotBlank((CharSequence)baseFilename) ? baseFilename : null;
                String newFileName = filename == null ? "clone." + ((OutputFormat)optionalOutputFormat.get()).getFileExtension() : ((lastDotIndex = filename.lastIndexOf(".")) > -1 ? filename.substring(0, lastDotIndex) + "_clone." + filename.substring(lastDotIndex + 1) : filename + "_clone." + ((OutputFormat)optionalOutputFormat.get()).getFileExtension());
                if (replaceLastPage.booleanValue() && this.determineMimeType(file).orElse(MimeType.PNG) == MimeType.PDF) {
                    byte[] mergedResult = PdfMerger.create().addPdf(file.getBytes(), true).addPdf(paymentPartReceipt.getData()).getPdf();
                    ResponseEntity responseEntity = this.responseHelper.buildResponse(mergedResult, newFileName);
                    return responseEntity;
                }
                ResponseEntity responseEntity = this.responseHelper.buildResponse((Output)paymentPartReceipt, newFileName);
                return responseEntity;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            return responseEntity;
        }
        catch (ParseException | ValidationException | DecodeException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    @Operation(summary="Create Payment Part & Receipts for a list of QrInvoices")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The payment part & receipts in the requested output format. Result is either a multi page PDF file or a ZIP file containing files for each list entry.")})
    @PostMapping(value={"/bulk/list"}, consumes={"application/json"}, produces={"application/pdf", "application/zip"})
    @ResponseBody
    public ResponseEntity<?> createPaymentPartReceipts(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="Font Family") @RequestParam(value="fontFamily", required=false, defaultValue="LIBERATION_SANS") FontFamilyEnum fontFamily, @Parameter(description="Embed Fonts in PDF") @RequestParam(value="fontsEmbedded", required=false, defaultValue="true") Boolean fontsEmbedded, @Parameter(description="Page Size") @RequestParam(value="pageSize", required=false, defaultValue="DIN_LANG") PageSizeEnum pageSize, @Parameter(description="Output Resolution") @RequestParam(value="resolution", required=false, defaultValue="MEDIUM_300_DPI") OutputResolutionEnum resolution, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoices") @RequestBody List<ch.codeblock.qrinvoice.rest.model.QrInvoice> qrInvoices) {
        Optional optionalOutputFormat = OutputFormat.getByMimeType((String)accept);
        if (!optionalOutputFormat.isPresent()) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        InboundModelMapper inboundModelMapper = InboundModelMapper.create((boolean)normalizeInput);
        int nr = 1;
        ArrayList<QrInvoice> mappedQrInvoices = new ArrayList<QrInvoice>();
        for (ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice : qrInvoices) {
            try {
                mappedQrInvoices.add(inboundModelMapper.map(qrInvoice));
            }
            catch (ValidationException e) {
                e.getValidationResult().addError("List", "Item", null, new String[]{String.format("Validation errors occurred on element nr. %s", nr)});
                return this.responseHelper.buildExceptionResponse((Exception)((Object)new ValidationException(e.getValidationResult())));
            }
            ++nr;
        }
        try {
            BulkOutput bulkOutput = QrInvoicePaymentPartReceiptBulkCreator.create().qrInvoices(mappedQrInvoices, qrInvoicePaymentPartReceiptCreator -> qrInvoicePaymentPartReceiptCreator.locale(this.requestParamHelper.toLocale(language)).fontFamily(this.requestParamHelper.toFontFamily(fontFamily)).pageSize(this.requestParamHelper.toPageSize(pageSize)).fontsEmbedded(BooleanUtils.toBooleanDefaultIfNull((Boolean)fontsEmbedded, (boolean)true)).outputFormat((OutputFormat)optionalOutputFormat.get()).outputResolution(this.requestParamHelper.toOutputResolution(resolution)).boundaryLines(this.requestParamHelper.toBoundaryLines(boundaryLines, boundaryLinesMargins)).boundaryLineScissors(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineScissors, (boolean)true)).boundaryLineSeparationText(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineSeparationText, (boolean)false)).additionalPrintMargin(BooleanUtils.toBooleanDefaultIfNull((Boolean)additionalPrintMargin, (boolean)false))).limit(1000).createAsMimeType((MimeType)MimeType.getByMimeType((String)accept).get());
            return this.buildBulkResponse(bulkOutput);
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Create Payment Part & Receipts as a bulk operation based on a given input file (CSV or XLSX). Result is either a multi page PDF file or a ZIP file containing files for each list entry.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The payment part & receipts in the requested output format.")})
    @PostMapping(value={"/bulk/file"}, consumes={"multipart/form-data"}, produces={"application/pdf", "application/zip"})
    @ResponseBody
    public ResponseEntity<?> bulk(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="CSV separator - only relevant for CSV files") @RequestPart(value="csvSeparator", required=false) String csvSeparator, @Parameter(description="File containing the list of data to generate from (CSV or XLSX)") @RequestPart(value="file") MultipartFile file) {
        Optional optionalMimeType = MimeType.getByMimeType((String)accept);
        if (!optionalMimeType.isPresent()) return this.responseHelper.requestedMimeTypeNotSupported(accept);
        if (!QrInvoicePaymentPartReceiptBulkCreator.create().isSupported((MimeType)optionalMimeType.get())) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        try (InputStream fileInputStream = file.getInputStream();){
            Optional inputMimeType = this.determineMimeType(file);
            if (inputMimeType.isPresent()) {
                BulkOutput bulkOutput = QrInvoicePaymentPartReceiptBulkCreator.create().inputMimeType((MimeType)inputMimeType.get()).csvSeparator(csvSeparator).inputStream(fileInputStream).limit(1000).createAsMimeType((MimeType)optionalMimeType.get());
                ResponseEntity responseEntity2 = this.buildBulkResponse(bulkOutput);
                return responseEntity2;
            }
            ResponseEntity responseEntity = this.responseHelper.inputMimeTypeNotSupported(file);
            return responseEntity;
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }

    private Optional<MimeType> determineMimeType(MultipartFile file) {
        Optional byMimeType = MimeType.getByMimeType((String)file.getContentType());
        if (byMimeType.isPresent()) {
            return byMimeType;
        }
        return MimeType.getByFilename((String)this.getOriginalBaseFilename(file));
    }

    private String getOriginalBaseFilename(MultipartFile file) {
        return FilenameUtils.getBaseName((String)file.getOriginalFilename());
    }

    private Optional<QrInvoiceDocumentScanner> getDocumentScanner(MimeType mimeType) {
        try {
            return Optional.of(QrInvoiceDocumentScanner.create((MimeType)mimeType));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private PaymentPartReceipt getPaymentPartReceipt(LanguageEnum languageEnum, FontFamilyEnum fontFamilyEnum, Boolean fontsEmbedded, PageSizeEnum pageSizeEnum, OutputResolutionEnum resolution, Boolean boundaryLines, Boolean boundaryLinesMargins, Boolean boundaryLineScissors, Boolean boundaryLineSeparationText, Boolean additionalPrintMargin, QrInvoice qrInvoice, OutputFormat outputFormat) {
        this.requestResponseLogger.logRequestData(qrInvoice);
        if (this.requestContext.isDemo()) {
            DemoValues.apply((QrInvoice)qrInvoice);
        }
        return QrInvoicePaymentPartReceiptCreator.create().qrInvoice(qrInvoice).locale(this.requestParamHelper.toLocale(languageEnum)).fontFamily(this.requestParamHelper.toFontFamily(fontFamilyEnum)).pageSize(this.requestParamHelper.toPageSize(pageSizeEnum)).fontsEmbedded(BooleanUtils.toBooleanDefaultIfNull((Boolean)fontsEmbedded, (boolean)true)).outputFormat(outputFormat).outputResolution(this.requestParamHelper.toOutputResolution(resolution)).boundaryLines(this.requestParamHelper.toBoundaryLines(boundaryLines, boundaryLinesMargins)).boundaryLineScissors(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineScissors, (boolean)true)).boundaryLineSeparationText(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineSeparationText, (boolean)false)).additionalPrintMargin(BooleanUtils.toBooleanDefaultIfNull((Boolean)additionalPrintMargin, (boolean)false)).createPaymentPartReceipt();
    }

    public ResponseEntity<?> buildBulkResponse(BulkOutput bulkOutput) {
        ApiRequestLoggingFilter.setItemCount((int)bulkOutput.getCount());
        return this.responseHelper.buildResponse(bulkOutput.getData(), String.format("%s.%s", PaymentPartReceipt.class.getSimpleName(), bulkOutput.getOutputFormat().getFileExtension()));
    }

    public ResponseEntity<?> buildResponse(PaymentPartReceipt output) {
        return this.responseHelper.buildResponse((Output)output, String.format("%s_%s.%s", output.getClass().getSimpleName(), output.getPageSize(), output.getOutputFormat().getFileExtension()));
    }
}

