/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.pdf.QrPdfMerger;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/pdf"})
@Tag(name="90 PDF")
public class PdfController {
    private final ResponseHelper responseHelper;

    public PdfController(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Operation(summary="Merge")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The merged PDF file")})
    @PostMapping(value={"/merge"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> merge(@Parameter(description="Base PDF file") @RequestParam(value="file") MultipartFile file, @Parameter(description="PDF file (single page) which should get merged onto the first document") @RequestParam(value="file2") MultipartFile file2, @Parameter(description="Page number on which to place the payment part receipt") @RequestParam(value="onPage", required=false, defaultValue="1") int onPage) {
        try {
            byte[] data = QrPdfMerger.create().mergePdfs(file.getBytes(), file2.getBytes(), onPage);
            return this.responseHelper.buildResponse(data, "merged.pdf");
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }

    @Operation(summary="Append")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The appended PDF file")})
    @PostMapping(value={"/append"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> append(@Parameter(description="Base PDF file") @RequestParam(value="file") MultipartFile file, @Parameter(description="PDF file which should be appended to the base file") @RequestParam(value="file2") MultipartFile file2) {
        try {
            ArrayList<byte[]> fileList = new ArrayList<byte[]>();
            fileList.add(file.getBytes());
            fileList.add(file2.getBytes());
            byte[] data = QrPdfMerger.create().appendPdfs(fileList);
            return this.responseHelper.buildResponse(data, "appended.pdf");
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }
}

