/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.model.billinformation.BillInformation;
import ch.codeblock.qrinvoice.model.billinformation.swicos1v12.SwicoS1v12;
import ch.codeblock.qrinvoice.model.parser.BillInformationParser;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.S1InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.S1OutboundModelMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/bill-information/swicos1v12"})
@Tag(name="30 Bill Information")
public class SwicoS1v12Controller {
    private final S1InboundModelMapper s1InboundModelMapper;
    private final S1OutboundModelMapper s1OutboundModelMapper;

    public SwicoS1v12Controller(S1InboundModelMapper s1InboundModelMapper, S1OutboundModelMapper s1OutboundModelMapper) {
        this.s1InboundModelMapper = s1InboundModelMapper;
        this.s1OutboundModelMapper = s1OutboundModelMapper;
    }

    @Operation(summary="Parse Bill Information as SwicoS1v12")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The parsed Bill Information", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.SwicoS1v12.class))}), @ApiResponse(responseCode="422", description="Unsupported bill information - not Swico S1 v1.2")})
    @PostMapping(value={"parse"}, consumes={"text/plain"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parseSwicoS1v12(@Parameter(description="Bill Information", name="billInformation") @RequestBody String billInformationStr) {
        BillInformation billInformation = BillInformationParser.create().parseBillInformation(billInformationStr);
        if (billInformation instanceof SwicoS1v12) {
            SwicoS1v12 s1 = (SwicoS1v12)billInformation;
            return ResponseEntity.ok((Object)this.s1OutboundModelMapper.map(s1));
        }
        return ResponseEntity.unprocessableEntity().body((Object)"Unsupported bill information type");
    }

    @Operation(summary="Serialize a SwicoS1v12 into Bill Information string")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The Bill Information string", content={@Content(schema=@Schema(implementation=String.class))})})
    @PostMapping(value={"create"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> createBillInformation(@Parameter(description="Swico S1 v1.2") @RequestBody ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.SwicoS1v12 s1) {
        SwicoS1v12 s1Mapped = this.s1InboundModelMapper.map(s1);
        s1Mapped.validate().throwExceptionOnErrors();
        return ResponseEntity.ok((Object)s1Mapped.toBillInformationString());
    }

    @Operation(summary="Validate a SwicoS1v12 object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid Swico S1 v1.2 data", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="422", description="Invalid Swico S1 v1.2 data", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"validate"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<?> validate(@Parameter(description="Swico S1 v1.2") @RequestBody ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.SwicoS1v12 s1) {
        SwicoS1v12 s1Mapped = this.s1InboundModelMapper.map(s1);
        ValidationResult result = s1Mapped.validate();
        if (result.isValid()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid Bill information: " + s1));
    }
}

