/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.BaseException;
import ch.codeblock.qrinvoice.QrInvoiceCodeCreator;
import ch.codeblock.qrinvoice.QrInvoiceCodeParser;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.util.DemoValues;
import ch.codeblock.qrinvoice.model.validation.QrInvoiceValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import ch.codeblock.qrinvoice.rest.api.RequestContext;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestResponseLogger;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.model.InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.OutboundModelMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/swiss-payments-code"})
@Tag(name="13 Swiss Payments Code")
public class SwissPaymentsCodeController {
    private final RequestContext requestContext;
    private final ResponseHelper responseHelper;
    private final RequestResponseLogger requestResponseLogger;

    @Autowired
    public SwissPaymentsCodeController(RequestContext requestContext, RequestResponseLogger requestResponseLogger, ResponseHelper responseHelper) {
        this.requestContext = requestContext;
        this.requestResponseLogger = requestResponseLogger;
        this.responseHelper = responseHelper;
    }

    @Operation(summary="Create Swiss Payments Code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The raw Swiss Payments Code (SPC)")})
    @PostMapping(consumes={"application/json"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> create(@Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoice", name="QrInvoice") @RequestBody ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice) {
        try {
            QrInvoice qrInvoiceMapped = InboundModelMapper.create((boolean)normalizeInput).map(qrInvoice);
            this.requestResponseLogger.logRequestData(qrInvoiceMapped);
            if (this.requestContext.isDemo()) {
                DemoValues.apply((QrInvoice)qrInvoiceMapped);
            }
            String spc = QrInvoiceCodeCreator.create().qrInvoice(qrInvoiceMapped).createSwissPaymentsCode();
            return this.responseHelper.utf8(ResponseEntity.ok()).body((Object)spc);
        }
        catch (BaseException e) {
            return this.responseHelper.buildExceptionResponse((Exception)((Object)e));
        }
    }

    @Operation(summary="Parse Swiss Payments Code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The QrInvoice Object", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.QrInvoice.class))})})
    @PostMapping(value={"parse"}, consumes={"text/plain"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parse(@Parameter(description="Swiss Payments Code", name="SwissPaymentsCode") @RequestBody String swissPaymentsCode) {
        try {
            QrInvoice qrInvoice = QrInvoiceCodeParser.create().parse(swissPaymentsCode);
            QrInvoiceValidator.create().validate(qrInvoice).throwExceptionOnErrors();
            this.requestResponseLogger.logResponseData(qrInvoice);
            return ResponseEntity.ok((Object)OutboundModelMapper.create().map(qrInvoice));
        }
        catch (BaseException e) {
            return this.responseHelper.buildExceptionResponse((Exception)((Object)e));
        }
    }

    @Operation(summary="Validates the given Swiss Payments Code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The validation result", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> validate(@Parameter(description="Swiss Payments Code", name="SwissPaymentsCode") @RequestBody String swissPaymentsCode) {
        try {
            QrInvoice qrInvoice = QrInvoiceCodeParser.create().parse(swissPaymentsCode);
            ValidationResult validationResult = QrInvoiceValidator.create().validate(qrInvoice);
            if (validationResult.isValid()) {
                return ResponseEntity.ok().build();
            }
            String validationErrorSummary = validationResult.getValidationErrorSummary();
            return this.responseHelper.okUtf8().body((Object)validationErrorSummary);
        }
        catch (BaseException e) {
            return this.responseHelper.buildExceptionResponse((Exception)((Object)e));
        }
    }
}

