/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.BaseException;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.OutputResolution;
import ch.codeblock.qrinvoice.QrInvoiceCodeCreator;
import ch.codeblock.qrinvoice.QrInvoiceCodeParser;
import ch.codeblock.qrinvoice.QrInvoiceCodeScanner;
import ch.codeblock.qrinvoice.QrInvoiceDocumentScanner;
import ch.codeblock.qrinvoice.model.ParseException;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.util.DemoValues;
import ch.codeblock.qrinvoice.model.validation.QrInvoiceValidator;
import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.model.validation.ValidationResult;
import ch.codeblock.qrinvoice.output.Output;
import ch.codeblock.qrinvoice.output.QrCode;
import ch.codeblock.qrinvoice.qrcode.DecodeException;
import ch.codeblock.qrinvoice.rest.api.RequestContext;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestResponseLogger;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.model.InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.OutboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.OutputResolutionEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/swiss-qr-code"})
@Tag(name="12 Swiss QR Code")
public class SwissQrCodeController {
    private final RequestContext requestContext;
    private final ResponseHelper responseHelper;
    private final RequestResponseLogger requestResponseLogger;

    public SwissQrCodeController(RequestContext requestContext, RequestResponseLogger requestResponseLogger, ResponseHelper responseHelper) {
        this.requestContext = requestContext;
        this.requestResponseLogger = requestResponseLogger;
        this.responseHelper = responseHelper;
    }

    @Operation(summary="Create Swiss QR Code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The QR code in the requested output format.")})
    @PostMapping(value={""}, consumes={"application/json"}, produces={"application/pdf", "image/png", "image/gif", "image/jpeg", "image/bmp", "image/tiff", "image/svg+xml"})
    @ResponseBody
    public ResponseEntity<?> create(@Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Output Resolution.") @RequestParam(value="resolution", required=false, defaultValue="MEDIUM_300_DPI") OutputResolutionEnum resolution, @Parameter(description="Desired QR Code size (in pixels). This is an alternative to Output Resolution. This is only relevant for raster graphics (e.g. PNG). Please note that it is only a hint.", content={@Content(schema=@Schema(example="500"))}) @RequestParam(value="size", required=false) Integer qrCodeSize, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="QrInvoice", name="QrInvoice") @RequestBody ch.codeblock.qrinvoice.rest.model.QrInvoice qrInvoice) {
        HashMap<String, Object> logParams = new HashMap<String, Object>();
        logParams.put("accept", accept);
        logParams.put("resolution", resolution);
        logParams.put("size", qrCodeSize);
        Optional outputFormat = OutputFormat.getByMimeType((String)accept);
        if (!outputFormat.isPresent()) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        try {
            QrInvoice qrInvoiceMapped = InboundModelMapper.create((boolean)normalizeInput).map(qrInvoice);
            this.requestResponseLogger.logRequestData(qrInvoiceMapped);
            if (this.requestContext.isDemo()) {
                DemoValues.apply((QrInvoice)qrInvoiceMapped);
            }
            QrInvoiceCodeCreator qrInvoiceCodeCreator = QrInvoiceCodeCreator.create().qrInvoice(qrInvoiceMapped).outputFormat((OutputFormat)outputFormat.get());
            if (qrCodeSize != null && qrCodeSize > -1) {
                qrInvoiceCodeCreator.desiredQrCodeSize(qrCodeSize.intValue());
            } else {
                qrInvoiceCodeCreator.outputResolution(OutputResolution.valueOf((String)resolution.getCode()));
            }
            QrCode qrCode = qrInvoiceCodeCreator.createQrCode();
            return this.buildResponse(qrCode);
        }
        catch (BaseException e) {
            return this.responseHelper.buildExceptionResponse((Exception)((Object)e));
        }
    }

    @Operation(summary="Validate file containing a single Swiss QR Code")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The validation result")})
    @PostMapping(value={"validate"}, consumes={"multipart/form-data"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> validate(@Parameter(description="QrInvoice", name="QR-Code") @RequestParam(value="file") MultipartFile file) {
        try {
            QrInvoice qrInvoice = QrInvoiceCodeScanner.create().scan(file.getBytes());
            ValidationResult validationResult = QrInvoiceValidator.create().validate(qrInvoice);
            if (validationResult.isValid()) {
                return ResponseEntity.ok().build();
            }
            String validationErrorSummary = validationResult.getValidationErrorSummary();
            return this.responseHelper.okUtf8().body((Object)validationErrorSummary);
        }
        catch (BaseException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Parse / extract Swiss QR Code from document (Returns first code if multiple present)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The parsed QR Invoice structure", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.QrInvoice.class))}), @ApiResponse(responseCode="404", description="No Swiss QR Code could be parsed / extracted from the given document")})
    @PostMapping(value={"/parse"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parse(@Parameter(description="If true, bill information will be expanded as object if present") @RequestParam(value="expandBillInformation", defaultValue="false") boolean expandBillInformation, @Parameter(description="QR bill to parse. Supported are PDFs and raster graphics such as JPEG and PNG.") @RequestParam(value="file") MultipartFile file) {
        Optional documentScannerOptional = this.getDocumentScanner(file.getContentType());
        if (!documentScannerOptional.isPresent()) {
            return this.missingDocumentScanner(file.getContentType());
        }
        QrInvoiceDocumentScanner documentScanner = (QrInvoiceDocumentScanner)documentScannerOptional.get();
        try (InputStream imageInputStream = file.getInputStream();){
            Optional qrInvoiceOptional = documentScanner.scanDocumentUntilFirstSwissQrCode(imageInputStream);
            if (qrInvoiceOptional.isPresent()) {
                ResponseEntity responseEntity2 = ResponseEntity.ok((Object)this.validateAndMap((QrInvoice)qrInvoiceOptional.get(), expandBillInformation));
                return responseEntity2;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            return responseEntity;
        }
        catch (ParseException | ValidationException | DecodeException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Parse / extract all Swiss QR Code from document in an array")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The parsed QR Invoices structure", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.QrInvoice.class))}), @ApiResponse(responseCode="404", description="No Swiss QR Code could be parsed / extracted from the given document")})
    @PostMapping(value={"/parseAll"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parseAll(@Parameter(description="If true, bill information will be expanded as object if present") @RequestParam(value="expandBillInformation", defaultValue="false") boolean expandBillInformation, @Parameter(description="QR bill to parse. Supported are PDFs and raster graphics such as JPEG and PNG.") @RequestParam(value="file") MultipartFile file) {
        Optional documentScannerOptional = this.getDocumentScanner(file.getContentType());
        if (!documentScannerOptional.isPresent()) {
            return this.missingDocumentScanner(file.getContentType());
        }
        QrInvoiceDocumentScanner documentScanner = (QrInvoiceDocumentScanner)documentScannerOptional.get();
        try (InputStream imageInputStream = file.getInputStream();){
            List qrInvoices = documentScanner.scanDocumentForAllSwissQrCodes(imageInputStream).stream().map(qrInvoice -> this.validateAndMap(qrInvoice, expandBillInformation)).collect(Collectors.toList());
            if (qrInvoices.isEmpty()) {
                ResponseEntity responseEntity2 = ResponseEntity.notFound().build();
                return responseEntity2;
            }
            ResponseEntity responseEntity = ResponseEntity.ok(qrInvoices);
            return responseEntity;
        }
        catch (ParseException | ValidationException | DecodeException | IOException e) {
            return this.responseHelper.buildExceptionResponse((Exception)e);
        }
    }

    private ch.codeblock.qrinvoice.rest.model.QrInvoice validateAndMap(QrInvoice qrInvoice, boolean expandBillInformation) {
        QrInvoiceValidator.create().validate(qrInvoice).throwExceptionOnErrors();
        if (expandBillInformation) {
            QrInvoiceCodeParser.create().applyBillInformationObject(qrInvoice);
        }
        this.requestResponseLogger.logResponseData(qrInvoice);
        return OutboundModelMapper.create().map(qrInvoice, expandBillInformation);
    }

    private Optional<QrInvoiceDocumentScanner> getDocumentScanner(String contentType) {
        try {
            return Optional.of(QrInvoiceDocumentScanner.create((String)contentType));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private ResponseEntity<?> missingDocumentScanner(String contentType) {
        return ResponseEntity.unprocessableEntity().contentType(MediaType.TEXT_PLAIN).body((Object)String.format("%s is not yet supported", contentType));
    }

    private ResponseEntity<?> buildResponse(QrCode output) {
        return this.responseHelper.buildResponse((Output)output, String.format("%s.%s", output.getClass().getSimpleName(), output.getOutputFormat().getFileExtension()));
    }
}

