/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.configuration;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@OpenAPIDefinition
public class SwaggerDocumentationConfig {
    @Value(value="${qrinvoice.artifact.version}")
    private String artifactVersion;

    @Bean
    public OpenAPI apiInfo() {
        return new OpenAPI().info(new Info().title("QR Invoice REST API").description("The QR Invoice REST API provides various services for creation and processing of Swiss QR Invoices.<br />Product Version: " + this.artifactVersion + "<br />" + "<br />Demo API Key: 582c9ea9-741a-4bb6-acae-cf92f8805864").license(new License().name("Commercial license").url("https://www.qr-invoice.ch/licenses/")).version("2.0").contact(new Contact().name("Codeblock GmbH").url("https://www.qr-invoice.ch").email("contact@codeblock.ch"))).components(new Components().addSecuritySchemes("api_key", new SecurityScheme().type(SecurityScheme.Type.APIKEY).description("API Key").name("api_key").in(SecurityScheme.In.QUERY))).security(Collections.singletonList(new SecurityRequirement().addList("api_key"))).tags(Arrays.asList(new Tag().name("00 Example Data").description("Various example data that can be used as example input to other services"), new Tag().name("10 QR Invoice Documents including Payment Part & Receipt (QR Bill) - Preview"), new Tag().name("11 Payment Part & Receipt (QR Bill)"), new Tag().name("12 Swiss QR Code"), new Tag().name("13 Swiss Payments Code"), new Tag().name("20 IBAN"), new Tag().name("21 QR Reference"), new Tag().name("22 Creditor Reference"), new Tag().name("23 Country Codes").description("According to ISO 3166-1 alpha-2"), new Tag().name("30 Bill Information"), new Tag().name("90 PDF"), new Tag().name("XX Deprecated QR Invoice Operations v1").description("Version 1 of QR Invoice REST API")));
    }

    @Bean
    public OpenApiCustomiser addDefaultResponsesPost() {
        return openApi -> openApi.getPaths().values().forEach(path -> {
            Operation operation = path.getPost();
            if (operation == null) {
                return;
            }
            ApiResponses apiResponses = operation.getResponses();
            apiResponses.addApiResponse("400", new ApiResponse().description("Bad request"));
            apiResponses.addApiResponse("401", new ApiResponse().description("Unauthorized"));
            apiResponses.addApiResponse("403", new ApiResponse().description("Forbidden"));
            apiResponses.addApiResponse("406", new ApiResponse().description("Not acceptable - please check content negotiation. Either 'Content-Type'- or 'Accept'-Header might not match this endpoint."));
            apiResponses.addApiResponse("422", new ApiResponse().description("Unprocessable entity - invalid or unsupported data."));
        });
    }

    @Bean
    public OpenApiCustomiser addDefaultResponsesGet() {
        return openApi -> openApi.getPaths().values().forEach(path -> {
            Operation operation = path.getGet();
            if (operation == null) {
                return;
            }
            ApiResponses apiResponses = operation.getResponses();
            apiResponses.addApiResponse("400", new ApiResponse().description("Bad request"));
            apiResponses.addApiResponse("401", new ApiResponse().description("Unauthorized"));
            apiResponses.addApiResponse("403", new ApiResponse().description("Forbidden"));
        });
    }
}

