/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActuatorFilter
implements Filter {
    private ServletContext context;
    @Value(value="${qrinvoice.actuator.key}")
    private String actuatorKey;

    public void init(FilterConfig filterConfig) {
        this.context = filterConfig.getServletContext();
        this.context.log("ActuatorFilter initialized - key is: " + this.actuatorKey);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String key = req.getParameter("key");
        if (this.actuatorKey != null && this.actuatorKey.equals(key)) {
            chain.doFilter(request, response);
        } else if (this.actuatorKey == null || this.actuatorKey.trim().isEmpty()) {
            this.context.log("HTTP Status 401 Unauthorized");
            res.setStatus(401);
            res.getWriter().print("Request parameter 'key' is missing for actuator access.");
        } else {
            this.context.log("HTTP Status 401 Unauthorized");
            res.setStatus(403);
            res.getWriter().print("Request parameter 'key' is invalid");
        }
    }

    public void destroy() {
    }
}

