/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.filter;

import ch.codeblock.qrinvoice.rest.api.RequestContext;
import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyFilter
implements Filter {
    private ServletContext context;
    private final RequestContext requestContext;
    @Value(value="${qrinvoice.apikey.enabled}")
    private String apiKeyEnabled;

    public ApiKeyFilter(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.context.log("ApiKeyFilter initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            if (Boolean.parseBoolean(this.apiKeyEnabled)) {
                if (this.requestContext.isApiKeyProvided()) {
                    Optional apiKeyOptional = this.requestContext.getApiKey();
                    if (apiKeyOptional.isPresent()) {
                        ApiKey apiKey = (ApiKey)apiKeyOptional.get();
                        MDC.put((String)"demoMode", (String)String.valueOf(apiKey.isDemo()));
                        MDC.put((String)"customerId", (String)String.valueOf(apiKey.getCustomerId()));
                        MDC.put((String)"apiKeyId", (String)String.valueOf(apiKey.getApiKeyId()));
                        chain.doFilter(request, response);
                    } else {
                        this.respondUnauthorized(res, "api_key is invalid");
                    }
                } else {
                    this.respondUnauthorized(res, "api_key query parameter is missing");
                }
            } else {
                String serverName = req.getServerName();
                boolean demoInstance = StringUtils.isNotBlank((CharSequence)serverName) && serverName.contains("demo.qr-invoice");
                MDC.put((String)"demoMode", (String)String.valueOf(demoInstance));
                chain.doFilter(request, response);
            }
        }
        finally {
            MDC.remove((String)"demoMode");
            MDC.remove((String)"customerId");
        }
    }

    private void respondUnauthorized(HttpServletResponse res, String s) throws IOException {
        this.context.log("HTTP Status 401 Unauthorized");
        res.setStatus(401);
        res.getWriter().print(s);
    }

    public void destroy() {
    }
}

