/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.filter;

import ch.codeblock.qrinvoice.rest.api.RequestContext;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestResponseLogger;
import ch.codeblock.qrinvoice.rest.management.RequestInfo;
import ch.codeblock.qrinvoice.rest.management.RequestReporter;
import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiRequestLoggingFilter
implements Filter {
    private static final String ITEM_COUNT = "itemCount";
    private static final Set<String> EXCLUDED_PARAMETERS = new HashSet<String>(Arrays.asList("api_key", "apikey", "qrInvoice", "QrInvoice", "qrInvoices", "QrInvoices"));
    private static final Set<String> INCLUDED_HEADERS = new HashSet<String>(Arrays.asList("accept", "accept-language", "content-type", "user-agent"));
    private final Logger logger = LoggerFactory.getLogger(RequestResponseLogger.class);
    private final RequestReporter requestReporter;
    private final RequestContext requestContext;

    public ApiRequestLoggingFilter(@Autowired(required=false) RequestReporter requestReporter, RequestContext requestContext) {
        this.requestReporter = requestReporter;
        this.requestContext = requestContext;
    }

    public void init(FilterConfig filterConfig) {
        ServletContext context = filterConfig.getServletContext();
        context.log("ApiRequestLoggingFilter initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LocalDateTime time = LocalDateTime.now();
        long start = System.currentTimeMillis();
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        Map headersToLog = this.collectHeaders(req);
        Map paramsToLog = this.collectParameters(req);
        StringBuilder sb = new StringBuilder();
        if (this.logger.isInfoEnabled()) {
            sb.append("url=").append(req.getRequestURL());
        }
        UUID requestId = UUID.randomUUID();
        try {
            MDC.put((String)"traceId", (String)requestId.toString());
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            String itemCount = MDC.get((String)ITEM_COUNT) == null ? "1" : MDC.get((String)ITEM_COUNT);
            MDC.remove((String)ITEM_COUNT);
            long end = System.currentTimeMillis();
            if (this.requestReporter != null) {
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.setRequestId(requestId);
                requestInfo.setTime(time);
                requestInfo.setUrl(req.getRequestURL().toString());
                requestInfo.setMethod(req.getMethod());
                requestInfo.setStatus(res.getStatus());
                requestInfo.setMillis(end - start);
                requestInfo.setCount(Integer.parseInt(itemCount));
                requestInfo.setHeaders(headersToLog);
                requestInfo.setParams(paramsToLog);
                requestInfo.setApiKey(this.requestContext.getApiKey().orElse(new ApiKey()).getApiKey());
                requestInfo.setAccept(req.getHeader("accept"));
                this.requestReporter.report(requestInfo);
            }
            if (this.logger.isInfoEnabled()) {
                sb.append(" ");
                sb.append("method=").append(req.getMethod());
                sb.append(" ");
                sb.append("status=").append(res.getStatus());
                sb.append(" time=").append(end - start).append(" ms");
                sb.append(" count=").append(itemCount);
                sb.append(" - ");
                this.logMap(sb, "headers", headersToLog);
                sb.append(" - ");
                this.logMap(sb, "params", paramsToLog);
                this.logger.info(sb.toString());
            }
            throw throwable;
        }
        String itemCount = MDC.get((String)ITEM_COUNT) == null ? "1" : MDC.get((String)ITEM_COUNT);
        MDC.remove((String)ITEM_COUNT);
        long end = System.currentTimeMillis();
        if (this.requestReporter != null) {
            RequestInfo requestInfo = new RequestInfo();
            requestInfo.setRequestId(requestId);
            requestInfo.setTime(time);
            requestInfo.setUrl(req.getRequestURL().toString());
            requestInfo.setMethod(req.getMethod());
            requestInfo.setStatus(res.getStatus());
            requestInfo.setMillis(end - start);
            requestInfo.setCount(Integer.parseInt(itemCount));
            requestInfo.setHeaders(headersToLog);
            requestInfo.setParams(paramsToLog);
            requestInfo.setApiKey(this.requestContext.getApiKey().orElse(new ApiKey()).getApiKey());
            requestInfo.setAccept(req.getHeader("accept"));
            this.requestReporter.report(requestInfo);
        }
        if (this.logger.isInfoEnabled()) {
            sb.append(" ");
            sb.append("method=").append(req.getMethod());
            sb.append(" ");
            sb.append("status=").append(res.getStatus());
            sb.append(" time=").append(end - start).append(" ms");
            sb.append(" count=").append(itemCount);
            sb.append(" - ");
            this.logMap(sb, "headers", headersToLog);
            sb.append(" - ");
            this.logMap(sb, "params", paramsToLog);
            this.logger.info(sb.toString());
        }
    }

    private Map<String, Object> collectHeaders(HttpServletRequest req) {
        LinkedHashMap<String, Object> headersToLog = new LinkedHashMap<String, Object>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!INCLUDED_HEADERS.contains(headerName.toLowerCase())) continue;
            headersToLog.put(headerName, req.getHeader(headerName));
        }
        return headersToLog;
    }

    private Map<String, Object> collectParameters(HttpServletRequest req) {
        LinkedHashMap<String, Object> paramsToLog = new LinkedHashMap<String, Object>();
        Map parameterMap = req.getParameterMap();
        for (Map.Entry stringEntry : parameterMap.entrySet()) {
            if (EXCLUDED_PARAMETERS.contains(stringEntry.getKey())) continue;
            if (stringEntry.getValue() == null || ((String[])stringEntry.getValue()).length == 0) {
                paramsToLog.put((String)stringEntry.getKey(), "");
                continue;
            }
            if (((String[])stringEntry.getValue()).length == 1) {
                paramsToLog.put((String)stringEntry.getKey(), ((String[])stringEntry.getValue())[0]);
                continue;
            }
            paramsToLog.put((String)stringEntry.getKey(), String.join((CharSequence)", ", (CharSequence[])stringEntry.getValue()));
        }
        return paramsToLog;
    }

    private void logMap(StringBuilder sb, String groupName, Map<String, Object> map) {
        sb.append(groupName).append(" {");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            first = false;
        }
        sb.append("}");
    }

    public static void setItemCount(int itemCount) {
        MDC.put((String)ITEM_COUNT, (String)String.valueOf(itemCount));
    }

    public void destroy() {
    }
}

