/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.management;

import ch.codeblock.qrinvoice.rest.model.security.ApiKeyReader;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class ApiKeyFetcher {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyFetcher.class);
    private final ApiKeyRegistry apiKeyRegistry;
    private final DataSource dataSource;

    public ApiKeyFetcher(ApiKeyRegistry apiKeyRegistry, DataSource dataSource) {
        this.apiKeyRegistry = apiKeyRegistry;
        this.dataSource = dataSource;
    }

    @Scheduled(initialDelay=20000L, fixedDelay=300000L)
    public void fetchApiKeys() {
        this.logger.info("Going to read latest API Keys from central registry");
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("select json from api_keys_json");
            if (rs.next()) {
                String json = rs.getString("json");
                this.apiKeyRegistry.updateKeys(new ApiKeyReader().read(json));
            }
        }
        catch (Exception e) {
            this.logger.warn("Error occurred during fetching of api keys", (Throwable)e);
        }
    }
}

