/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.management;

import ch.codeblock.qrinvoice.rest.management.RequestInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class RequestReporter {
    private final Logger logger = LoggerFactory.getLogger(RequestReporter.class);
    private final ConcurrentLinkedQueue<RequestInfo> infosToReport = new ConcurrentLinkedQueue();
    private final DataSource dataSource;

    public RequestReporter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void report(RequestInfo toReport) {
        this.infosToReport.offer(toReport);
    }

    @Scheduled(fixedDelay=20000L)
    public void reportToDb() {
        if (this.infosToReport.isEmpty()) {
            this.logger.info("No requests to be reported");
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("insert into request_log (request_id, \"timestamp\", path, method, status, accept, ms, api_key)\nvalues (?, ?, ?, ?, ?, ?, ?, ?)");){
            int batchSize = 50;
            RequestInfo info = (RequestInfo)this.infosToReport.poll();
            int count = 1;
            while (info != null) {
                stmt.setObject(1, info.getRequestId());
                stmt.setTimestamp(2, Timestamp.valueOf(info.getTime()));
                stmt.setString(3, info.getUrl());
                stmt.setString(4, info.getMethod());
                stmt.setInt(5, info.getStatus());
                stmt.setString(6, info.getAccept());
                stmt.setLong(7, info.getMillis());
                stmt.setObject(8, UUID.fromString(info.getApiKey()));
                stmt.addBatch();
                if (count % batchSize == 0) {
                    this.executeBatch(stmt);
                }
                ++count;
                info = (RequestInfo)this.infosToReport.poll();
            }
            this.executeBatch(stmt);
        }
        catch (Exception e) {
            this.logger.warn("Error occurred during reporting of requests", (Throwable)e);
        }
    }

    private void executeBatch(PreparedStatement statement) throws SQLException {
        int[] counts = statement.executeBatch();
        this.logger.info("Reported {} records", (Object)Arrays.stream(counts).sum());
    }
}

