/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12;

import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.ImportTaxPosition;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.PaymentCondition;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.SwicoS1v12;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.VatDetails;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class S1OutboundModelMapper {
    public SwicoS1v12 map(ch.codeblock.qrinvoice.model.billinformation.swicos1v12.SwicoS1v12 s1) {
        SwicoS1v12 result = new SwicoS1v12();
        result.setBillInformationType(s1.getBillInformationType());
        result.setInvoiceReference(s1.getInvoiceReference());
        result.setInvoiceDate(s1.getInvoiceDate());
        result.setCustomerReference(s1.getCustomerReference());
        result.setUidNumber(s1.getUidNumber());
        result.setVatDateStart(s1.getVatDateStart());
        result.setVatDateEnd(s1.getVatDateEnd());
        result.setVatDetails(this.mapVatDetails(s1.getVatDetails()));
        result.setImportTaxes(this.mapImportTaxes(s1.getImportTaxes()));
        result.setPaymentConditions(this.mapPaymentConditions(s1.getPaymentConditions()));
        return result;
    }

    private PaymentCondition[] mapPaymentConditions(List<ch.codeblock.qrinvoice.model.billinformation.swicos1v12.PaymentCondition> paymentConditions) {
        if (paymentConditions == null) {
            return null;
        }
        ArrayList<PaymentCondition> result = new ArrayList<PaymentCondition>();
        for (ch.codeblock.qrinvoice.model.billinformation.swicos1v12.PaymentCondition paymentCondition : paymentConditions) {
            PaymentCondition e = new PaymentCondition();
            e.setCashDiscountPercentage(paymentCondition.getCashDiscountPercentage());
            e.setEligiblePaymentPeriodDays(paymentCondition.getEligiblePaymentPeriodDays());
            result.add(e);
        }
        return result.toArray(new PaymentCondition[0]);
    }

    private VatDetails[] mapVatDetails(List<ch.codeblock.qrinvoice.model.billinformation.swicos1v12.VatDetails> vatDetails) {
        if (vatDetails == null) {
            return null;
        }
        ArrayList<VatDetails> result = new ArrayList<VatDetails>();
        for (ch.codeblock.qrinvoice.model.billinformation.swicos1v12.VatDetails vatDetail : vatDetails) {
            VatDetails e = new VatDetails();
            e.setTaxedNetAmount(vatDetail.getTaxedNetAmount());
            e.setTaxPercentage(vatDetail.getTaxPercentage());
            result.add(e);
        }
        return result.toArray(new VatDetails[0]);
    }

    private ImportTaxPosition[] mapImportTaxes(List<ch.codeblock.qrinvoice.model.billinformation.swicos1v12.ImportTaxPosition> importTaxes) {
        if (importTaxes == null) {
            return null;
        }
        ArrayList<ImportTaxPosition> result = new ArrayList<ImportTaxPosition>();
        for (ch.codeblock.qrinvoice.model.billinformation.swicos1v12.ImportTaxPosition importTaxPosition : importTaxes) {
            ImportTaxPosition e = new ImportTaxPosition();
            e.setTaxAmount(importTaxPosition.getTaxAmount());
            e.setTaxPercentage(importTaxPosition.getTaxPercentage());
            result.add(e);
        }
        return result.toArray(new ImportTaxPosition[0]);
    }
}

