/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model.security;

import ch.codeblock.qrinvoice.rest.model.security.ApiKeyFileWatcher;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyFileWatcher {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyFileWatcher.class);
    @Value(value="${qrinvoice.apikey.path}")
    private String apiKeyPath;
    private final ApiKeyRegistry apiKeyRegistry;
    private ExecutorService executorService;
    @Value(value="${qrinvoice.apikey.enabled}")
    private String apiKeyEnabled;

    @Autowired
    public ApiKeyFileWatcher(ApiKeyRegistry apiKeyRegistry) {
        this.apiKeyRegistry = apiKeyRegistry;
    }

    @PostConstruct
    public void initFileWatchService() throws IOException {
        if (Boolean.parseBoolean(this.apiKeyEnabled)) {
            this.executorService = Executors.newSingleThreadExecutor();
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Path path = Paths.get(this.apiKeyPath, new String[0]).getParent();
            if (Files.exists(path, new LinkOption[0])) {
                path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                1 runnable = new /* Unavailable Anonymous Inner Class!! */;
                this.executorService.submit((Runnable)runnable);
            } else {
                this.logger.warn("Path does not exist: {}", (Object)path);
            }
        }
    }

    static /* synthetic */ ApiKeyRegistry access$000(ApiKeyFileWatcher x0) {
        return x0.apiKeyRegistry;
    }

    static /* synthetic */ String access$100(ApiKeyFileWatcher x0) {
        return x0.apiKeyPath;
    }

    static /* synthetic */ Logger access$200(ApiKeyFileWatcher x0) {
        return x0.logger;
    }
}

