/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.model.billinformation.BillInformation;
import ch.codeblock.qrinvoice.model.billinformation.RawBillInformation;
import ch.codeblock.qrinvoice.model.billinformation.RawBillInformationType;
import ch.codeblock.qrinvoice.model.billinformation.swicos1v12.SwicoS1v12;
import ch.codeblock.qrinvoice.model.parser.BillInformationParser;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.model.billinformation.RawOutboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.S1OutboundModelMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/bill-information/"})
@Tag(name="30 Bill Information")
public class BillInformationController {
    private final S1OutboundModelMapper s1OutboundModelMapper;
    private final RawOutboundModelMapper rawOutboundModelMapper;

    public BillInformationController(S1OutboundModelMapper s1OutboundModelMapper, RawOutboundModelMapper rawOutboundModelMapper) {
        this.s1OutboundModelMapper = s1OutboundModelMapper;
        this.rawOutboundModelMapper = rawOutboundModelMapper;
    }

    @Operation(summary="Parse Bill Information including optional Swico information")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The parsed Bill Information", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.billinformation.BillInformation.class))}), @ApiResponse(responseCode="422", description="Unsupported bill information structure", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"parse"}, consumes={"text/plain"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parseBillInformation(@Parameter(description="Bill Information") @RequestBody String billInformationStr) {
        BillInformation billInformation = BillInformationParser.create().parseBillInformation(billInformationStr);
        if (billInformation instanceof SwicoS1v12) {
            SwicoS1v12 s1 = (SwicoS1v12)billInformation;
            return ResponseEntity.ok((Object)this.s1OutboundModelMapper.map(s1));
        }
        if (billInformation instanceof RawBillInformation) {
            RawBillInformation rawBillInformation = (RawBillInformation)billInformation;
            return ResponseEntity.ok((Object)this.rawOutboundModelMapper.map(rawBillInformation));
        }
        return ResponseEntity.unprocessableEntity().body((Object)"Unsupported bill information type");
    }

    @Operation(summary="Parse Raw Bill Information")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The parsed Bill Information", content={@Content(schema=@Schema(implementation=ch.codeblock.qrinvoice.rest.model.billinformation.BillInformation.class))}), @ApiResponse(responseCode="422", description="Unsupported bill information structure", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"parse/raw"}, consumes={"text/plain"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> parseRawBillInformation(@Parameter(description="Bill Information") @RequestBody String billInformationStr) {
        RawBillInformation billInformation = RawBillInformationType.getInstance().parse(billInformationStr);
        if (billInformation != null) {
            return ResponseEntity.ok((Object)this.rawOutboundModelMapper.map(billInformation));
        }
        return ResponseEntity.unprocessableEntity().body((Object)"Unsupported bill information type - only raw supported here");
    }
}

