/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.util.CreditorReferenceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/creditor-reference"})
@Tag(name="22 Creditor Reference")
public class CreditorReferenceController {
    @Operation(summary="Validate a creditor reference number")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Creditor reference is valid", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="422", description="Invalid creditor reference", content={@Content(schema=@Schema(hidden=true))})})
    @PostMapping(value={"validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> validate(@Parameter(description="creditor reference", content={@Content(schema=@Schema(example="RF45 1234 5123 45"))}) @RequestBody String creditorReference) {
        if (CreditorReferenceUtils.isValidCreditorReference((String)creditorReference)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid creditor reference for: " + creditorReference));
    }

    @Operation(summary="Create a creditor reference. If the passed creditor reference is missing prefix and checksum, it is calculated and appended.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid creditor reference including checksum"), @ApiResponse(responseCode="422", description="Invalid creditor reference - checksum could not be added")})
    @PostMapping(value={"create"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> create(@Parameter(description="Creditor reference", content={@Content(schema=@Schema(example="42"))}) @RequestBody String creditorReference, @Parameter(description="If true, creditor reference is formatted in response") @RequestParam(required=false, defaultValue="false") boolean formatCreditorReference) {
        try {
            return ResponseEntity.ok((Object)this.formatCreditorReferenceNumber(CreditorReferenceUtils.createCreditorReference((String)creditorReference), formatCreditorReference));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.unprocessableEntity().body((Object)("Invalid creditor reference" + creditorReference + ", could not be created."));
        }
    }

    @Operation(summary="Format a Creditor Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid Creditor Reference"), @ApiResponse(responseCode="422", description="Invalid Creditor Reference")})
    @PostMapping(value={"format"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> format(@Parameter(description="Creditor Reference", content={@Content(schema=@Schema(example="RF451234512345"))}) @RequestBody String creditorReference) {
        if (CreditorReferenceUtils.isValidCreditorReference((String)creditorReference)) {
            return ResponseEntity.ok((Object)CreditorReferenceUtils.formatCreditorReference((String)creditorReference));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid Creditor Reference " + creditorReference + ", could not be formatted."));
    }

    @Operation(summary="Normalize a Creditor Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Normalized Creditor Reference"), @ApiResponse(responseCode="422", description="Invalid Creditor Reference")})
    @PostMapping(value={"normalize"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> normalize(@Parameter(description="Creditor Reference", content={@Content(schema=@Schema(example="RF451234512345"))}) @RequestBody String creditorReference) {
        if (CreditorReferenceUtils.isValidCreditorReference((String)creditorReference)) {
            return ResponseEntity.ok((Object)CreditorReferenceUtils.normalizeCreditorReference((String)creditorReference));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid Creditor Reference  " + creditorReference + ", could not be normalized."));
    }

    @Operation(summary="Calculate Check Digits using Modulo 97 if the given input would be added to creditor reference RF<checkdigits><input>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Check Digits for Input"), @ApiResponse(responseCode="422", description="Invalid Creditor Reference")})
    @PostMapping(value={"modulo97"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> modulo97(@Parameter(description="number", content={@Content(schema=@Schema(example="42"))}) @RequestBody String number) {
        try {
            return ResponseEntity.ok((Object)CreditorReferenceUtils.calculateCheckDigitsForReferenceNumber((String)number));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.unprocessableEntity().body((Object)("Unprocessable number " + number));
        }
    }

    private String formatCreditorReferenceNumber(String creditorReferenceNumber, boolean creditorReferenceNumberFormat) {
        if (creditorReferenceNumberFormat) {
            return CreditorReferenceUtils.formatCreditorReference((String)creditorReferenceNumber);
        }
        return creditorReferenceNumber;
    }
}

