/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/examples"})
@Tag(name="00 Example Data")
public class ExampleMiscController {
    @Operation(summary="IBAN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="IBAN")})
    @GetMapping(value={"iban"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> iban() {
        return ResponseEntity.ok((Object)"CH3709000000304442225");
    }

    @Operation(summary="QR-IBAN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QR-IBAN")})
    @GetMapping(value={"qr-iban"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> qrIban() {
        return ResponseEntity.ok((Object)"CH4431999123000889012");
    }

    @Operation(summary="QR Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QR Reference")})
    @GetMapping(value={"qr-reference"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> qrReference() {
        return ResponseEntity.ok((Object)"210000000003139471430009017");
    }

    @Operation(summary="Creditor Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Creditor Reference")})
    @GetMapping(value={"creditor-reference"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> creditorReference() {
        return ResponseEntity.ok((Object)"RF18539007547034");
    }

    @Operation(summary="Swico S1 v1.2")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swico S1 v1.2")})
    @GetMapping(value={"swicos1v12"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> swicos1v12() {
        return ResponseEntity.ok((Object)"//S1/10/10201409/11/190512/20/1400.000-53/30/106017086/31/180508/32/7.7/40/2:10;0:30");
    }
}

