/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.bulk.csv.Csv;
import ch.codeblock.qrinvoice.bulk.excel.Xlsx;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.SwissPaymentsCode;
import ch.codeblock.qrinvoice.model.mapper.SwissPaymentsCodeToModelMapper;
import ch.codeblock.qrinvoice.model.parser.SwissPaymentsCodeParser;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.model.OutboundModelMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/examples/qr-invoice"})
@Tag(name="00 Example Data")
public class ExampleQrInvoiceController {
    @Operation(summary="QrInvoice - Example with QR Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"with-qr-reference"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> qrReference() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n1949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nInstruction of 03.04.2019\nEPD\n//S1/10/10201409/11/190512/20/1400.000-53/30/106017086/31/180508/32/7.7/40/2:10;0:30\nName AV1: UV;UltraPay005;12345\nName AV2: XY;XYService;54321"));
    }

    @Operation(summary="QrInvoice - Example with Creditor Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"with-creditor-reference"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> creditorReference() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH5800791123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n199.95\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nSCOR\nRF18539007547034\n\nEPD\n\n\n"));
    }

    @Operation(summary="QrInvoice - Example without Reference Number")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"without-reference"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> nonReference() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH3709000000304442225\nS\nRobert Schneider AG\nRue du Lac\n1268/2/22\n2501\nBiel\nCH\n\n\n\n\n\n\n\n3949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nNON\n\nRechnung Nr. 3139 f\u00fcr Gartenarbeiten und Entsorgung Schnittmaterial\nEPD\n\n\n"));
    }

    @Operation(summary="QrInvoice - Example without Amount")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"without-amount"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> withoutAmount() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nDonation to the Winterfest Campaign\nEPD\n\n\n"));
    }

    @Operation(summary="QrInvoice - Example without Amount and Debtor (blank)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"blank"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> blank() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH3709000000304442225\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\n\n\n\n\n\n\n\nNON\n\nDonation to the Winterfest Campaign\nEPD\n\n\n"));
    }

    @Operation(summary="QrInvoice - Example with combined address")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"combined-address"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ch.codeblock.qrinvoice.rest.model.QrInvoice> qrReferenceCombinedAddress() {
        return ResponseEntity.ok((Object)this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nK\nRobert Schneider AG\nRue du Lac 1268\n2501 Biel\n\n\nCH\n\n\n\n\n\n\n\n1949.75\nCHF\nK\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse 28\n9400 Rorschach\n\n\nCH\nQRR\n210000000003139471430009017\nInstruction of 03.04.2019\nEPD\n\n\n"));
    }

    @Operation(summary="QrInvoice - Example with a list of QR invoices")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoices")})
    @GetMapping(value={"bulk/list"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<ch.codeblock.qrinvoice.rest.model.QrInvoice>> list() {
        return ResponseEntity.ok(Arrays.asList(this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nK\nRobert Schneider AG\nRue du Lac 1268\n2501 Biel\n\n\nCH\n\n\n\n\n\n\n\n1949.75\nCHF\nK\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse 28\n9400 Rorschach\n\n\nCH\nQRR\n210000000003139471430009017\nInstruction of 03.04.2019\nEPD\n\n\n"), this.toResponseModel("SPC\n0200\n1\nCH3709000000304442225\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\n\n\n\n\n\n\n\nNON\n\nDonation to the Winterfest Campaign\nEPD\n\n\n"), this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nDonation to the Winterfest Campaign\nEPD\n\n\n"), this.toResponseModel("SPC\n0200\n1\nCH3709000000304442225\nS\nRobert Schneider AG\nRue du Lac\n1268/2/22\n2501\nBiel\nCH\n\n\n\n\n\n\n\n3949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nNON\n\nRechnung Nr. 3139 f\u00fcr Gartenarbeiten und Entsorgung Schnittmaterial\nEPD\n\n\n"), this.toResponseModel("SPC\n0200\n1\nCH5800791123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n199.95\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nSCOR\nRF18539007547034\n\nEPD\n\n\n"), this.toResponseModel("SPC\n0200\n1\nCH4431999123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n1949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nInstruction of 03.04.2019\nEPD\n//S1/10/10201409/11/190512/20/1400.000-53/30/106017086/31/180508/32/7.7/40/2:10;0:30\nName AV1: UV;UltraPay005;12345\nName AV2: XY;XYService;54321")));
    }

    @Operation(summary="QrInvoice - Example CSV file that is used as input for bulk operation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"bulk/csv"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> csv() throws IOException {
        return new ResponseHelper().buildResponse(Csv.getExample(), "example.csv");
    }

    @Operation(summary="QrInvoice - Example Excel (XLSX) file that is used as input for bulk operation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QrInvoice")})
    @GetMapping(value={"bulk/xlsx"}, consumes={"*/*"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    @ResponseBody
    public ResponseEntity<?> xlsx() throws IOException {
        return new ResponseHelper().buildResponse(Xlsx.getExample(), "example.xlsx");
    }

    private ch.codeblock.qrinvoice.rest.model.QrInvoice toResponseModel(String spcString) {
        SwissPaymentsCode spc = SwissPaymentsCodeParser.create().parse(spcString);
        QrInvoice qrInvoice = SwissPaymentsCodeToModelMapper.create().map(spc);
        return OutboundModelMapper.create().map(qrInvoice);
    }
}

