/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/examples/swiss-payments-code"})
@Tag(name="00 Example Data")
public class ExampleSpcController {
    @Operation(summary="Swiss Payments Code - Example with QR Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swiss Payments Code (SPC)")})
    @GetMapping(value={"with-qr-reference"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> qrReference() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("content-type", new String[]{"text/plain;charset=UTF-8"})).body((Object)"SPC\n0200\n1\nCH4431999123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n1949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nInstruction of 03.04.2019\nEPD\n//S1/10/10201409/11/190512/20/1400.000-53/30/106017086/31/180508/32/7.7/40/2:10;0:30\nName AV1: UV;UltraPay005;12345\nName AV2: XY;XYService;54321");
    }

    @Operation(summary="Swiss Payments Code - Example with Creditor Reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swiss Payments Code (SPC)")})
    @GetMapping(value={"with-creditor-reference"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> creditorReference() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("content-type", new String[]{"text/plain;charset=UTF-8"})).body((Object)"SPC\n0200\n1\nCH5800791123000889012\nS\nRobert Schneider AG\nRue du Lac\n1268\n2501\nBiel\nCH\n\n\n\n\n\n\n\n199.95\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nSCOR\nRF18539007547034\n\nEPD\n\n\n");
    }

    @Operation(summary="Swiss Payments Code - Example without Reference Number")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swiss Payments Code (SPC)")})
    @GetMapping(value={"without-reference"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> nonReference() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("content-type", new String[]{"text/plain;charset=UTF-8"})).body((Object)"SPC\n0200\n1\nCH3709000000304442225\nS\nRobert Schneider AG\nRue du Lac\n1268/2/22\n2501\nBiel\nCH\n\n\n\n\n\n\n\n3949.75\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nNON\n\nRechnung Nr. 3139 f\u00fcr Gartenarbeiten und Entsorgung Schnittmaterial\nEPD\n\n\n");
    }

    @Operation(summary="Swiss Payments Code - Example without Amount")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swiss Payments Code (SPC)")})
    @GetMapping(value={"without-amount"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> withoutAmount() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("content-type", new String[]{"text/plain;charset=UTF-8"})).body((Object)"SPC\n0200\n1\nCH4431999123000889012\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\nS\nPia-Maria Rutschmann-Schnyder\nGrosse Marktgasse\n28\n9400\nRorschach\nCH\nQRR\n210000000003139471430009017\nDonation to the Winterfest Campaign\nEPD\n\n\n");
    }

    @Operation(summary="Swiss Payments Code - Example without Amount and Debtor (blank)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swiss Payments Code (SPC)")})
    @GetMapping(value={"blank"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> blank() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("content-type", new String[]{"text/plain;charset=UTF-8"})).body((Object)"SPC\n0200\n1\nCH3709000000304442225\nS\nSalvation Army Foundation Switzerland\n\n\n3000\nBerne\nCH\n\n\n\n\n\n\n\n\nCHF\n\n\n\n\n\n\n\nNON\n\nDonation to the Winterfest Campaign\nEPD\n\n\n");
    }
}

