/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.util.IbanUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/iban"})
@Tag(name="20 IBAN")
public class IbanController {
    @Operation(summary="Validate an IBAN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="IBAN is valid"), @ApiResponse(responseCode="422", description="Invalid IBAN")})
    @PostMapping(value={"validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> validateIban(@Parameter(description="IBAN", content={@Content(schema=@Schema(example="CH3908704016075473007", hidden=true))}) @RequestBody String iban) {
        if (IbanUtils.isValidIBAN((String)iban, (boolean)true)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid IBAN: " + iban));
    }

    @Operation(summary="Format an IBAN. Works for QR-IBAN too.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid IBAN"), @ApiResponse(responseCode="422", description="Invalid IBAN")})
    @PostMapping(value={"format"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> format(@Parameter(description="IBAN", content={@Content(schema=@Schema(example="CH3908704016075473007"))}) @RequestBody String iban) {
        if (IbanUtils.isValidIBAN((String)iban, (boolean)false)) {
            return ResponseEntity.ok((Object)IbanUtils.formatIban((String)iban));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid IBAN: " + iban));
    }

    @Operation(summary="Normalize an IBAN. Works for QR-IBAN too.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Normalized IBAN"), @ApiResponse(responseCode="422", description="Invalid IBAN")})
    @PostMapping(value={"normalize"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> normalize(@Parameter(description="IBAN", content={@Content(schema=@Schema(example="CH3908704016075473007"))}) @RequestBody String iban) {
        if (IbanUtils.isValidIBAN((String)iban, (boolean)false)) {
            return ResponseEntity.ok((Object)IbanUtils.normalizeIBAN((String)iban));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid IBAN: " + iban));
    }
}

