/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.MimeType;
import ch.codeblock.qrinvoice.OutputFormat;
import ch.codeblock.qrinvoice.documents.DocumentTemplateRepository;
import ch.codeblock.qrinvoice.documents.QrInvoiceDocumentCreator;
import ch.codeblock.qrinvoice.documents.model.DocumentTemplate;
import ch.codeblock.qrinvoice.documents.model.application.builder.DocumentLayoutBuilder;
import ch.codeblock.qrinvoice.documents.model.application.layout.DocumentLayout;
import ch.codeblock.qrinvoice.documents.model.application.layout.Resource;
import ch.codeblock.qrinvoice.documents.output.QrInvoiceDocument;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.validation.ValidationException;
import ch.codeblock.qrinvoice.output.Output;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestParamHelper;
import ch.codeblock.qrinvoice.rest.api.v2.helper.RequestResponseLogger;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.model.InvoiceDocumentInboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.LanguageEnum;
import ch.codeblock.qrinvoice.rest.model.documents.InvoiceDocument;
import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import ch.codeblock.qrinvoice.rest.resources.CustomerResourcesRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/invoice-document"})
@Tag(name="10 QR Invoice Documents including Payment Part & Receipt (QR Bill) - Preview")
public class InvoiceDocumentController {
    private final RequestResponseLogger requestResponseLogger;
    private final ResponseHelper responseHelper;
    private final RequestParamHelper requestParamHelper;
    private final ApiKeyRegistry apiKeyRegistry;
    private final CustomerResourcesRepository customerResourcesRepository;

    @Autowired
    public InvoiceDocumentController(RequestResponseLogger requestResponseLogger, ResponseHelper responseHelper, RequestParamHelper requestParamHelper, ApiKeyRegistry apiKeyRegistry, CustomerResourcesRepository customerResourcesRepository) {
        this.requestResponseLogger = requestResponseLogger;
        this.responseHelper = responseHelper;
        this.requestParamHelper = requestParamHelper;
        this.apiKeyRegistry = apiKeyRegistry;
        this.customerResourcesRepository = customerResourcesRepository;
    }

    @Operation(summary="Create a QR Invoice Document (QR Bill)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The QR Invoice Document as PDF")})
    @PostMapping(value={""}, consumes={"application/json"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> createInvoiceDocument(@Parameter(hidden=true) @RequestParam(value="api_key", required=false) String apiKey, @Parameter(hidden=true) @RequestHeader(value="Accept") String accept, @Parameter(description="Locale") @RequestHeader(value="Accept-Language", required=false, defaultValue="de") LanguageEnum language, @Parameter(description="If a line should be printed to mark the payment parts and receipts boundary. This should be true in all cases except the invoice is printed to perforated paper.") @RequestParam(value="boundaryLines", required=false, defaultValue="true") Boolean boundaryLines, @Parameter(description="If the boundary lines should include a margin and not extend to the border of the page. Printers usually are unable to print the lines completely otherwise.") @RequestParam(value="boundaryLinesMargins", required=false, defaultValue="false") Boolean boundaryLinesMargins, @Parameter(description="If scissors should be printed on the boundary lines. Only to be set to true if parameter boundaryLines is set to true.") @RequestParam(value="boundaryLineScissors", required=false, defaultValue="true") Boolean boundaryLineScissors, @Parameter(description="If a separation label should be printed above the payment part. This can be used as an alternative or in addition to boundaryLineScissors.") @RequestParam(value="boundaryLineSeparationText", required=false, defaultValue="false") Boolean boundaryLineSeparationText, @Parameter(description="If an additional print margin (1mm) should be added to the left, right and bottom of the payment part & receipt. If set, 6mm instead of 5mm print margin is used. This may be needed some printers and print services") @RequestParam(value="additionalPrintMargin", required=false, defaultValue="false") Boolean additionalPrintMargin, @Parameter(description="If true, input gets normalized. This means strings are trimmed, special quotations replaced with ASCII ones and special characters replaced with semantically equal ones (e.g. \u0153 -> oe)") @RequestParam(value="normalizeInput", required=false, defaultValue="false") Boolean normalizeInput, @Parameter(description="The Logo to be used - must be previously uploaded as customer resource") @RequestParam(value="logoResource", required=false) String logoResource, @Parameter(description="Invoice Document Template") @RequestParam(value="templateId", required=false, defaultValue="STANDARD_RECIPIENT_RIGHT_V1") String templateId, @Parameter(description="True if the total amount in the QR Payment Part & Receipt should be calculated") @RequestParam(value="calculateAmount", required=false, defaultValue="true") Boolean calculateAmount, @Parameter(description="The InvoiceDocument") @RequestBody InvoiceDocument invoiceDocument) {
        Optional optionalOutputFormat = OutputFormat.getByMimeType((String)accept);
        if (!optionalOutputFormat.isPresent()) {
            return this.responseHelper.requestedMimeTypeNotSupported(accept);
        }
        try {
            Integer customerId = this.apiKeyRegistry.getApiKey(apiKey).map(ApiKey::getCustomerId).orElse(null);
            Optional logoFile = this.customerResourcesRepository.getFile(customerId, logoResource);
            DocumentTemplate documentTemplate = (DocumentTemplate)DocumentTemplateRepository.getByExternalIdentifier((String)templateId).orElseThrow(() -> new ValidationException("Unable to find template with identifier: " + templateId));
            ch.codeblock.qrinvoice.documents.model.application.InvoiceDocument mappedInvoiceDocument = InvoiceDocumentInboundModelMapper.create((boolean)normalizeInput).map(invoiceDocument).calculate();
            if (calculateAmount.booleanValue()) {
                QrInvoice qrInvoice = mappedInvoiceDocument.getQrInvoice();
                if (qrInvoice.getPaymentAmountInformation().getAmount() == null) {
                    mappedInvoiceDocument.applyCurrencyAmount(qrInvoice);
                } else {
                    throw new ValidationException("Requested amount calculation for the QR Payment Part & Receipt but value was already set in the QrInvoice object");
                }
            }
            this.requestResponseLogger.logRequestData(mappedInvoiceDocument);
            DocumentLayout invoiceLayout = DocumentLayoutBuilder.create().documentTemplate(documentTemplate).logo(this.mapLogoResource(logoFile)).build();
            QrInvoiceDocument document = QrInvoiceDocumentCreator.create().invoice(mappedInvoiceDocument).invoiceLayout(invoiceLayout).locale(this.requestParamHelper.toLocale(language)).boundaryLines(this.requestParamHelper.toBoundaryLines(boundaryLines, boundaryLinesMargins)).boundaryLineScissors(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineScissors, (boolean)true)).boundaryLineSeparationText(BooleanUtils.toBooleanDefaultIfNull((Boolean)boundaryLineSeparationText, (boolean)false)).additionalPrintMargin(BooleanUtils.toBooleanDefaultIfNull((Boolean)additionalPrintMargin, (boolean)false)).createDocument();
            return this.responseHelper.buildResponse((Output)document, "QR-Invoice.pdf");
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }

    public Resource mapLogoResource(Optional<Path> logoFileOptional) {
        if (logoFileOptional.isPresent()) {
            Path logoFile = logoFileOptional.get();
            MimeType mimeType = (MimeType)MimeType.getByFilename((String)logoFile.toFile().getName()).orElseThrow(() -> new RuntimeException("Unsupported mimeType"));
            return new Resource(mimeType, logoFile.toFile());
        }
        return null;
    }
}

