/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyRegistry;
import ch.codeblock.qrinvoice.rest.resources.CustomerResourcesRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/invoice-document/resources"})
@Tag(name="10 QR Invoice Documents including Payment Part & Receipt (QR Bill) - Preview")
public class InvoiceDocumentResourcesController {
    private final ResponseHelper responseHelper;
    private final CustomerResourcesRepository customerResourcesRepository;
    private final ApiKeyRegistry apiKeyRegistry;

    @Autowired
    public InvoiceDocumentResourcesController(ResponseHelper responseHelper, CustomerResourcesRepository customerResourcesRepository, ApiKeyRegistry apiKeyRegistry) {
        this.responseHelper = responseHelper;
        this.customerResourcesRepository = customerResourcesRepository;
        this.apiKeyRegistry = apiKeyRegistry;
    }

    @Operation(summary="Add new customer resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Resource created or updated successfully")})
    @PostMapping(value={"/{filename}"}, consumes={"multipart/form-data"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<?> addCustomerResource(@RequestParam(value="api_key", required=false) String apiKey, @PathVariable(value="filename") String filename, @Parameter(description="Base PDF file") @RequestParam(value="file") MultipartFile file) {
        try {
            Integer customerId = this.apiKeyRegistry.getApiKey(apiKey).map(ApiKey::getCustomerId).orElse(null);
            Path resourceFile = this.customerResourcesRepository.writeFile(customerId, filename, file.getInputStream());
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }

    @Operation(summary="List customer resources")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="TODO")})
    @GetMapping(value={""}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> listCustomerResources(@RequestParam(value="api_key", required=false) String apiKey) {
        try {
            Integer customerId = this.apiKeyRegistry.getApiKey(apiKey).map(ApiKey::getCustomerId).orElse(null);
            Path customerDir = this.customerResourcesRepository.getCustomerDir(customerId);
            TreeSet files = new TreeSet();
            Files.list(customerDir).map(f -> f.toFile().getName()).forEach(files::add);
            return ResponseEntity.ok(files);
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }
}

