/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.documents.DocumentTemplateRepository;
import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.rest.api.v2.InvoiceDocumentTemplateController;
import ch.codeblock.qrinvoice.rest.api.v2.helper.ResponseHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/invoice-document"})
@Tag(name="10 QR Invoice Documents including Payment Part & Receipt (QR Bill) - Preview")
public class InvoiceDocumentTemplateController {
    private final ResponseHelper responseHelper;

    @Autowired
    public InvoiceDocumentTemplateController(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Operation(summary="List Available Invoice Document Templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of templates successfully returned")})
    @GetMapping(value={"templates"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> listTemplates(@Parameter(hidden=true) @RequestParam(value="api_key", required=false) String apiKey) {
        try {
            return ResponseEntity.ok(DocumentTemplateRepository.ALL.stream().map(tpl -> new InvoiceDocumentTemplate(tpl.getExternalIdentifier(), tpl.getDescription())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            return this.responseHelper.buildExceptionResponse(e);
        }
    }
}

