/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.util.IbanUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/qr-iban"})
@Tag(name="20 IBAN")
public class QrIbanController {
    @Operation(summary="Validate a QR IBAN. QR IBANs are regular IBANs. The only special thing is that the IID (institutional identification) is in the QR-IID range. QR-IIDs consist exclusively of numbers from 30000 to 31999.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="QR-IBAN  is valid"), @ApiResponse(responseCode="200", description="Invalid QR-IBAN")})
    @PostMapping(value={"/validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> validateQrIban(@Parameter(description="QR-IBAN", content={@Content(schema=@Schema(example="CH44 3199 9123 0008 8901 2"))}) @RequestBody String qrIban) {
        if (IbanUtils.isQrIBAN((String)qrIban)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid QR-IBAN for: " + qrIban));
    }
}

