/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2;

import ch.codeblock.qrinvoice.rest.api.annotation.ExposedApi;
import ch.codeblock.qrinvoice.util.QRReferenceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ExposedApi
@RestController
@RequestMapping(value={"/v2/qr-reference"}, method={RequestMethod.POST})
@Tag(name="21 QR Reference")
public class QrReferenceController {
    private final Logger logger = LoggerFactory.getLogger(QrReferenceController.class);

    @Operation(summary="Validate a QR reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid QR reference"), @ApiResponse(responseCode="422", description="Invalid QR reference")})
    @PostMapping(value={"validate"}, consumes={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> validate(@Parameter(description="QR reference", content={@Content(schema=@Schema(example="00 00000 00000 00000 12345 67894"))}) @RequestBody String qrReference) {
        if (QRReferenceUtils.isValidQrReference((String)qrReference)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid QR reference. " + qrReference));
    }

    @Operation(summary="Create a QR reference with an optional customer ID. If the passed QR reference is missing checksum, it is calculated and appended.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid QR reference including checksum"), @ApiResponse(responseCode="422", description="Invalid QR reference - checksum could not be added")})
    @PostMapping(value={"create"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> create(@Parameter(description="QR reference", content={@Content(schema=@Schema(example="123"))}) @RequestBody String qrReference, @Parameter(description="If true, QR reference is formatted in response") @RequestParam(required=false, defaultValue="false") boolean formatQrReference, @Parameter(description="Optional customer ID as prefix to the reference") @RequestParam(required=false, defaultValue="") String customerId) {
        try {
            return ResponseEntity.ok((Object)this.formatQrReferenceNumber(QRReferenceUtils.createQrReference((String)customerId, (String)qrReference), formatQrReference));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.unprocessableEntity().body((Object)("Invalid QR reference " + qrReference + ", (Customer ID: " + customerId + ") could not be created."));
        }
    }

    @Operation(summary="Format a QR reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Valid QR reference"), @ApiResponse(responseCode="422", description="Invalid QR reference")})
    @PostMapping(value={"format"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> format(@Parameter(description="QR reference", content={@Content(schema=@Schema(example="000000000000000001234567894"))}) @RequestBody String qrReference) {
        if (QRReferenceUtils.isValidQrReference((String)qrReference)) {
            return ResponseEntity.ok((Object)QRReferenceUtils.formatQrReference((String)qrReference));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid QR reference " + qrReference + ", could not be formatted."));
    }

    @Operation(summary="Normalize a QR reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Normalized QR reference"), @ApiResponse(responseCode="422", description="Invalid QR reference")})
    @PostMapping(value={"normalize"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> normalize(@Parameter(description="QR reference", content={@Content(schema=@Schema(example="00 00000 00000 00000 12345 67894"))}) @RequestBody String qrReference) {
        if (QRReferenceUtils.isValidQrReference((String)qrReference)) {
            return ResponseEntity.ok((Object)QRReferenceUtils.normalizeQrReference((String)qrReference));
        }
        return ResponseEntity.unprocessableEntity().body((Object)("Invalid QR reference  " + qrReference + ", could not be normalized."));
    }

    @Operation(summary="Calculate Check Digit by Modulo 10 recursive")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Check Digit for Input"), @ApiResponse(responseCode="422", description="Invalid QR reference")})
    @PostMapping(value={"modulo10recursive"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<?> modulo10recursive(@Parameter(description="number", content={@Content(schema=@Schema(example="123"))}) @RequestBody String number) {
        try {
            return ResponseEntity.ok((Object)String.valueOf(QRReferenceUtils.modulo10Recursive((String)number)));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.unprocessableEntity().body((Object)("Unprocessable number " + number));
        }
    }

    private String formatQrReferenceNumber(String qrReferenceNumber, boolean qrReferenceNumberFormat) {
        if (qrReferenceNumberFormat) {
            return QRReferenceUtils.formatQrReference((String)qrReferenceNumber);
        }
        return qrReferenceNumber;
    }
}

