/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2.examples;

import ch.codeblock.qrinvoice.documents.model.application.AdditionalProperty;
import ch.codeblock.qrinvoice.documents.model.application.InvoiceDocument;
import ch.codeblock.qrinvoice.documents.model.application.builder.AmountBuilder;
import ch.codeblock.qrinvoice.documents.model.application.builder.InvoiceDocumentBuilder;
import ch.codeblock.qrinvoice.model.QrInvoice;
import ch.codeblock.qrinvoice.model.builder.QrInvoiceBuilder;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Currency;

public class ExampleInvoiceDocuments {
    public static final InvoiceDocument INVOICE_DOCUMENT_MIXED_VAT = ExampleInvoiceDocuments.createMixedVatDocument();
    public static final InvoiceDocument INVOICE_DOCUMENT_DISCOUNTS = ExampleInvoiceDocuments.createDiscountsDocument();
    public static final InvoiceDocument INVOICE_DOCUMENT_GTIN = ExampleInvoiceDocuments.createGtinDocument();

    private static InvoiceDocument createDiscountsDocument() {
        InvoiceDocumentBuilder invoiceBuilder = InvoiceDocumentBuilder.create().invoiceNr("re-00013").title("QR-Invoice Java Solutions").customerNr("123").customerReference("Kundenreferenz").invoiceDate(LocalDate.now()).invoiceDueDate(LocalDate.now().plusDays(30L)).termOfPaymentDays(Integer.valueOf(30)).contactPerson(c -> c.name("Claude Gex").email("claude.gex@codeblock.ch")).currency(Currency.getInstance("CHF")).prefaceText(t -> t.append("Sehr geehrte Damen und Herren").lineBreak().append("Wir danken Ihnen f\u00fcr Ihren Auftrag und stellen Ihnen wie folgt in Rechnung")).endingText(t -> t.append("F\u00fcr Fragen stehen wir Ihnen jederzeit gerne zur Verf\u00fcgung.").lineBreaks(2).append("Freundliche Gr\u00fcsse").lineBreaks(3).append("Hans Muster AG")).sender(s -> s.addAddressLine("Hans Muster AG").addAddressLine("Hauptstrasse 1").addAddressLine("3232 Ins").addAddressLine("Schweiz")).recipient(r -> r.addAddressLine("Kunde AG").addAddressLine("Am Weg 42").addAddressLine("3000 Bern").addAddressLine("Schweiz")).addPosition(p -> p.position(Integer.valueOf(1)).description(t -> t.append("This is simple but long string with lorem ipsum text").lineBreaks(2).append("generating some sort of natural text in order to test text wrapping")).quantity(Integer.valueOf(12)).unitPriceVatExclusive(Double.valueOf(10.0)).vatPercentage(7.7).discountPercentage(10.0)).addPosition(p -> p.position(Integer.valueOf(2)).description("short text").quantity(Double.valueOf(3.2)).unitPriceVatExclusive(Double.valueOf(42.1)).vatPercentage(7.7).discountAbsolute(AmountBuilder.create().vatPercentage(7.7).vatExclusive(25.0).build())).addPosition(p -> p.position(Integer.valueOf(3)).description("Mineral").unit("Stk").quantity(Integer.valueOf(44)).unitPriceVatExclusive(Double.valueOf(1.0)).vatPercentage(2.5)).addPosition(p -> p.position(Integer.valueOf(4)).description("Customer discount").quantity(Integer.valueOf(1)).unitPriceVatExclusive(Double.valueOf(-100.0)).vatPercentage(7.7));
        InvoiceDocument invoiceDocument = invoiceBuilder.build().calculate();
        QrInvoice qrInvoice = invoiceDocument.applyCurrencyAmount(QrInvoiceBuilder.create()).creditorIBAN("CH44 3199 9123 0008 8901 2").creditor(c -> c.structuredAddress().name("Hans Muster AG").streetName("Hauptstrasse").houseNumber("1").postalCode("3232").city("Ins").country("CH")).ultimateDebtor(d -> d.combinedAddress().name("Kunde AG").addressLine1("Am Weg 42").addressLine2("3000 Bern").country("CH")).paymentReference(r -> r.qrReference("210000000003139471430009017")).additionalInformation(a -> a.unstructuredMessage("Invoice Document Example")).build();
        invoiceDocument.setQrInvoice(qrInvoice);
        return invoiceDocument;
    }

    private static InvoiceDocument createGtinDocument() {
        InvoiceDocumentBuilder invoiceBuilder = InvoiceDocumentBuilder.create().invoiceNr("re-00013").title("QR-Invoice Java Solutions").customerNr("123").customerReference("Kundenreferenz").invoiceDate(LocalDate.now()).invoiceDueDate(LocalDate.now().plusDays(30L)).termOfPaymentDays(Integer.valueOf(30)).contactPerson(c -> c.name("Claude Gex").email("claude.gex@codeblock.ch")).currency(Currency.getInstance("CHF")).prefaceText(t -> t.append("Sehr geehrte Damen und Herren").lineBreak().append("Wir danken Ihnen f\u00fcr Ihren Auftrag und stellen Ihnen wie folgt in Rechnung")).endingText(t -> t.append("F\u00fcr Fragen stehen wir Ihnen jederzeit gerne zur Verf\u00fcgung.").lineBreaks(2).append("Freundliche Gr\u00fcsse").lineBreaks(3).append("Hans Muster AG")).sender(s -> s.addAddressLine("Hans Muster AG").addAddressLine("Hauptstrasse 1").addAddressLine("3232 Ins").addAddressLine("Schweiz")).recipient(r -> r.addAddressLine("Kunde AG").addAddressLine("Am Weg 42").addAddressLine("3000 Bern").addAddressLine("Schweiz")).addPosition(p -> p.position(Integer.valueOf(1)).description(t -> t.append("This is simple but long string with lorem ipsum text").lineBreaks(2).append("generating some sort of natural text in order to test text wrapping")).quantity(Integer.valueOf(12)).unitPriceVatExclusive(Double.valueOf(10.0)).vatPercentage(7.7).additionalProperties(Collections.singletonList(new AdditionalProperty("GTIN", "01827304879014")))).addPosition(p -> p.position(Integer.valueOf(2)).description("short text").quantity(Double.valueOf(3.2)).unitPriceVatExclusive(Double.valueOf(42.1)).vatPercentage(7.7).additionalProperties(Collections.singletonList(new AdditionalProperty("GTIN", "01827304879021")))).addPosition(p -> p.position(Integer.valueOf(3)).description("Mineral").unit("Stk").quantity(Integer.valueOf(44)).unitPriceVatExclusive(Double.valueOf(1.0)).vatPercentage(2.5).additionalProperties(Collections.singletonList(new AdditionalProperty("GTIN", "01827304879038")))).addPosition(p -> p.description("This is a text only position"));
        InvoiceDocument invoiceDocument = invoiceBuilder.build().calculate();
        QrInvoice qrInvoice = invoiceDocument.applyCurrencyAmount(QrInvoiceBuilder.create()).creditorIBAN("CH44 3199 9123 0008 8901 2").creditor(c -> c.structuredAddress().name("Hans Muster AG").streetName("Hauptstrasse").houseNumber("1").postalCode("3232").city("Ins").country("CH")).ultimateDebtor(d -> d.combinedAddress().name("Kunde AG").addressLine1("Am Weg 42").addressLine2("3000 Bern").country("CH")).paymentReference(r -> r.qrReference("210000000003139471430009017")).additionalInformation(a -> a.unstructuredMessage("Invoice Document Example")).build();
        invoiceDocument.setQrInvoice(qrInvoice);
        return invoiceDocument;
    }

    private static InvoiceDocument createMixedVatDocument() {
        InvoiceDocumentBuilder invoiceBuilder = InvoiceDocumentBuilder.create().invoiceNr("re-00013").title("QR-Invoice Java Solutions").customerNr("123").customerReference("Kundenreferenz").invoiceDate(LocalDate.now()).invoiceDueDate(LocalDate.now().plusDays(30L)).termOfPaymentDays(Integer.valueOf(30)).contactPerson(c -> c.name("Claude Gex").email("claude.gex@codeblock.ch")).currency(Currency.getInstance("CHF")).prefaceText(t -> t.append("Sehr geehrte Damen und Herren").lineBreak().append("Wir danken Ihnen f\u00fcr Ihren Auftrag und stellen Ihnen wie folgt in Rechnung")).endingText(t -> t.append("F\u00fcr Fragen stehen wir Ihnen jederzeit gerne zur Verf\u00fcgung.").lineBreaks(2).append("Freundliche Gr\u00fcsse").lineBreaks(3).append("Hans Muster AG")).sender(s -> s.addAddressLine("Hans Muster AG").addAddressLine("Hauptstrasse 1").addAddressLine("3232 Ins").addAddressLine("Schweiz")).recipient(r -> r.addAddressLine("Kunde AG").addAddressLine("Am Weg 42").addAddressLine("3000 Bern").addAddressLine("Schweiz")).addPosition(p -> p.position(Integer.valueOf(1)).description(t -> t.append("This is simple but long string with lorem ipsum text").lineBreaks(2).append("generating some sort of natural text in order to test text wrapping")).quantity(Integer.valueOf(12)).unitPriceVatExclusive(Double.valueOf(10.0)).vatPercentage(7.7)).addPosition(p -> p.position(Integer.valueOf(2)).description("short text").quantity(Double.valueOf(3.2)).unitPriceVatExclusive(Double.valueOf(42.1)).vatPercentage(7.7)).addPosition(p -> p.position(Integer.valueOf(3)).description("Mineral").unit("Stk").quantity(Integer.valueOf(44)).unitPriceVatExclusive(Double.valueOf(1.0)).vatPercentage(2.5)).addPosition(p -> p.description("This is a text only position"));
        InvoiceDocument invoiceDocument = invoiceBuilder.build().calculate();
        QrInvoice qrInvoice = invoiceDocument.applyCurrencyAmount(QrInvoiceBuilder.create()).creditorIBAN("CH44 3199 9123 0008 8901 2").creditor(c -> c.structuredAddress().name("Hans Muster AG").streetName("Hauptstrasse").houseNumber("1").postalCode("3232").city("Ins").country("CH")).ultimateDebtor(d -> d.combinedAddress().name("Kunde AG").addressLine1("Am Weg 42").addressLine2("3000 Bern").country("CH")).paymentReference(r -> r.qrReference("210000000003139471430009017")).additionalInformation(a -> a.unstructuredMessage("Invoice Document Example")).build();
        invoiceDocument.setQrInvoice(qrInvoice);
        return invoiceDocument;
    }
}

