/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.api.v2.helper;

import ch.codeblock.qrinvoice.MimeType;
import ch.codeblock.qrinvoice.output.Output;
import ch.codeblock.qrinvoice.util.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ResponseHelper {
    private final Logger logger = LoggerFactory.getLogger(ResponseHelper.class);

    public ResponseEntity<?> buildResponse(Output output, String fileName) {
        return this.buildResponse(output.getData(), fileName);
    }

    public ResponseEntity<?> buildResponse(byte[] output, String fileName) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Description", "File Transfer");
        headers.add("Content-Disposition", "attachment; filename=" + fileName);
        headers.add("content-length", String.valueOf(output.length));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)output);
    }

    public ResponseEntity<String> buildExceptionResponse(Exception e) {
        this.logger.info(e.getMessage(), (Throwable)e);
        return this.utf8(ResponseEntity.badRequest()).body((Object)e.getMessage());
    }

    public ResponseEntity.BodyBuilder okUtf8() {
        return this.utf8(ResponseEntity.ok());
    }

    public ResponseEntity.BodyBuilder utf8(ResponseEntity.BodyBuilder responseEntity) {
        return (ResponseEntity.BodyBuilder)responseEntity.header("content-type", new String[]{"text/plain;charset=UTF-8"});
    }

    public ResponseEntity<?> requestedMimeTypeNotSupported(String accept) {
        return ResponseEntity.badRequest().body((Object)String.format("Requested MimeType (Accept Header) '%s' is not supported", accept));
    }

    public ResponseEntity<?> inputMimeTypeNotSupported(MultipartFile file) {
        return this.inputMimeTypeNotSupported(StringUtils.isNotBlank((CharSequence)file.getContentType()) ? file.getContentType() : FilenameUtils.getBaseName((String)file.getOriginalFilename()));
    }

    public ResponseEntity<?> inputMimeTypeNotSupported(MimeType mimeType) {
        return this.inputMimeTypeNotSupported(mimeType.getMimeType());
    }

    public ResponseEntity<?> inputMimeTypeNotSupported(String mimeType) {
        return ResponseEntity.unprocessableEntity().contentType(MediaType.TEXT_PLAIN).body((Object)String.format("%s is not yet supported", mimeType));
    }
}

