/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model;

import ch.codeblock.qrinvoice.model.ReferenceType;
import ch.codeblock.qrinvoice.model.builder.QrInvoiceBuilder;
import ch.codeblock.qrinvoice.model.util.StringNormalizer;
import ch.codeblock.qrinvoice.rest.model.AdditionalInformation;
import ch.codeblock.qrinvoice.rest.model.AddressTypeEnum;
import ch.codeblock.qrinvoice.rest.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.rest.model.Creditor;
import ch.codeblock.qrinvoice.rest.model.CreditorInformation;
import ch.codeblock.qrinvoice.rest.model.InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.rest.model.PaymentReference;
import ch.codeblock.qrinvoice.rest.model.QrInvoice;
import ch.codeblock.qrinvoice.rest.model.UltimateCreditor;
import ch.codeblock.qrinvoice.rest.model.UltimateDebtor;
import ch.codeblock.qrinvoice.util.StringUtils;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;

public class InboundModelMapper {
    private final boolean normalizeString;

    public static InboundModelMapper create(boolean normalizeString) {
        return new InboundModelMapper(normalizeString);
    }

    public InboundModelMapper() {
        this(false);
    }

    public InboundModelMapper(boolean normalizeString) {
        this.normalizeString = normalizeString;
    }

    public ch.codeblock.qrinvoice.model.QrInvoice map(QrInvoice qrInvoiceRest) {
        QrInvoiceBuilder builder = QrInvoiceBuilder.create();
        this.mapCreditorInformation(builder, qrInvoiceRest.getCreditorInformation());
        this.mapUltimateCreditor(builder, qrInvoiceRest.getUltimateCreditor());
        this.mapUltimateDebtor(builder, qrInvoiceRest.getUltimateDebtor());
        this.mapPaymentReference(builder, qrInvoiceRest.getPaymentReference());
        this.mapPaymentAmountInformation(builder, qrInvoiceRest.getPaymentAmountInformation());
        this.mapAlternativeSchemes(builder, qrInvoiceRest.getAlternativeSchemes());
        return builder.build();
    }

    private void mapCreditorInformation(QrInvoiceBuilder builder, CreditorInformation creditorInformation) {
        if (creditorInformation != null) {
            builder.creditorIBAN(this.normalize(creditorInformation.getIban()));
            Creditor creditor = creditorInformation.getCreditor();
            if (creditor != null) {
                this.validateAddressTypeNotNull(creditor.getAddressType());
                switch (1.$SwitchMap$ch$codeblock$qrinvoice$rest$model$AddressTypeEnum[creditor.getAddressType().ordinal()]) {
                    case 1: {
                        builder.creditor(c -> c.structuredAddress().name(this.normalize(creditor.getName())).streetName(this.normalize(creditor.getStreetName())).houseNumber(this.normalize(creditor.getHouseNumber())).postalCode(this.normalize(creditor.getPostalCode())).city(this.normalize(creditor.getCity())).country(this.normalize(creditor.getCountry())));
                        break;
                    }
                    case 2: {
                        builder.creditor(c -> c.combinedAddress().name(this.normalize(creditor.getName())).addressLine1(this.normalize(creditor.getAddressLine1())).addressLine2(this.normalize(creditor.getAddressLine2())).country(this.normalize(creditor.getCountry())));
                    }
                }
            }
        }
    }

    private void mapUltimateCreditor(QrInvoiceBuilder builder, UltimateCreditor ultimateCreditor) {
        if (ultimateCreditor != null) {
            this.validateAddressTypeNotNull(ultimateCreditor.getAddressType());
            switch (1.$SwitchMap$ch$codeblock$qrinvoice$rest$model$AddressTypeEnum[ultimateCreditor.getAddressType().ordinal()]) {
                case 1: {
                    builder.ultimateCreditor(u -> u.structuredAddress().name(this.normalize(ultimateCreditor.getName())).streetName(this.normalize(ultimateCreditor.getStreetName())).houseNumber(this.normalize(ultimateCreditor.getHouseNumber())).postalCode(this.normalize(ultimateCreditor.getPostalCode())).city(this.normalize(ultimateCreditor.getCity())).country(this.normalize(ultimateCreditor.getCountry())));
                    break;
                }
                case 2: {
                    builder.ultimateCreditor(u -> u.combinedAddress().name(this.normalize(ultimateCreditor.getName())).addressLine1(this.normalize(ultimateCreditor.getAddressLine1())).addressLine2(this.normalize(ultimateCreditor.getAddressLine2())).country(this.normalize(ultimateCreditor.getCountry())));
                }
            }
        }
    }

    private void mapUltimateDebtor(QrInvoiceBuilder builder, UltimateDebtor ultimateDebtor) {
        if (ultimateDebtor != null && (StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getName()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getStreetName()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getHouseNumber()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getAddressLine1()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getAddressLine2()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getPostalCode()) || StringUtils.isNotEmpty((CharSequence)ultimateDebtor.getCity()))) {
            this.validateAddressTypeNotNull(ultimateDebtor.getAddressType());
            switch (1.$SwitchMap$ch$codeblock$qrinvoice$rest$model$AddressTypeEnum[ultimateDebtor.getAddressType().ordinal()]) {
                case 1: {
                    builder.ultimateDebtor(u -> u.structuredAddress().name(this.normalize(ultimateDebtor.getName())).streetName(this.normalize(ultimateDebtor.getStreetName())).houseNumber(this.normalize(ultimateDebtor.getHouseNumber())).postalCode(this.normalize(ultimateDebtor.getPostalCode())).city(this.normalize(ultimateDebtor.getCity())).country(this.normalize(ultimateDebtor.getCountry())));
                    break;
                }
                case 2: {
                    builder.ultimateDebtor(u -> u.combinedAddress().name(this.normalize(ultimateDebtor.getName())).addressLine1(this.normalize(ultimateDebtor.getAddressLine1())).addressLine2(this.normalize(ultimateDebtor.getAddressLine2())).country(this.normalize(ultimateDebtor.getCountry())));
                }
            }
        }
    }

    private void validateAddressTypeNotNull(AddressTypeEnum addressType) {
        if (addressType == null) {
            throw new RuntimeException("Address type must be set");
        }
    }

    private void mapPaymentReference(QrInvoiceBuilder builder, PaymentReference paymentReference) {
        if (paymentReference == null) {
            return;
        }
        if (paymentReference.getReferenceType() != null) {
            builder.paymentReference().referenceType(ReferenceType.valueOf((String)this.normalize(paymentReference.getReferenceType().name())));
        }
        builder.paymentReference().reference(StringUtils.emptyStringAsNull((String)this.normalize(paymentReference.getReference())));
        this.mapAdditionalInformation(builder, paymentReference.getAdditionalInformation());
    }

    private void mapAdditionalInformation(QrInvoiceBuilder builder, AdditionalInformation additionalInformation) {
        if (additionalInformation == null) {
            return;
        }
        if (additionalInformation.getBillInformationObject() != null) {
            throw new RuntimeException("Not yet supported to pass bill information as object");
        }
        builder.additionalInformation().unstructuredMessage(StringUtils.emptyStringAsNull((String)this.normalize(additionalInformation.getUnstructuredMessage())));
        builder.additionalInformation().billInformation(StringUtils.emptyStringAsNull((String)this.normalize(additionalInformation.getBillInformation())));
    }

    private void mapPaymentAmountInformation(QrInvoiceBuilder builder, PaymentAmountInformation paymentAmountInformation) {
        if (paymentAmountInformation == null) {
            return;
        }
        if (paymentAmountInformation.getAmount() != null) {
            builder.paymentAmountInformation().amount(paymentAmountInformation.getAmount());
        }
        if (paymentAmountInformation.getCurrency() != null) {
            builder.paymentAmountInformation().currency(Currency.getInstance(paymentAmountInformation.getCurrency().name()));
        }
    }

    private void mapAlternativeSchemes(QrInvoiceBuilder builder, AlternativeSchemes alternativeSchemes) {
        if (alternativeSchemes != null) {
            List alternativeSchemeParameters = Arrays.stream(alternativeSchemes.getAlternativeSchemeParameters()).map(arg_0 -> this.normalize(arg_0)).collect(Collectors.toList());
            builder.alternativeSchemeParameters(alternativeSchemeParameters);
        }
    }

    private String normalize(String str) {
        if (!this.normalizeString || str == null) {
            return str;
        }
        return StringNormalizer.create().enableAll().normalize(str);
    }
}

