/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model;

import ch.codeblock.qrinvoice.documents.model.application.Amount;
import ch.codeblock.qrinvoice.documents.model.application.Percentage;
import ch.codeblock.qrinvoice.documents.model.application.builder.AmountBuilder;
import ch.codeblock.qrinvoice.documents.model.application.builder.InvoiceDocumentBuilder;
import ch.codeblock.qrinvoice.documents.model.application.builder.PositionBuilder;
import ch.codeblock.qrinvoice.rest.model.InboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.documents.AdditionalProperty;
import ch.codeblock.qrinvoice.rest.model.documents.Address;
import ch.codeblock.qrinvoice.rest.model.documents.InvoiceDocument;
import ch.codeblock.qrinvoice.rest.model.documents.Position;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InvoiceDocumentInboundModelMapper {
    private final boolean normalizeString;

    public InvoiceDocumentInboundModelMapper(boolean normalizeString) {
        this.normalizeString = normalizeString;
    }

    public static InvoiceDocumentInboundModelMapper create(boolean normalizeString) {
        return new InvoiceDocumentInboundModelMapper(normalizeString);
    }

    public ch.codeblock.qrinvoice.documents.model.application.InvoiceDocument map(InvoiceDocument invoiceDocument) {
        return InvoiceDocumentBuilder.create().customerNr(invoiceDocument.getCustomerNr()).customerReference(invoiceDocument.getCustomerReference()).invoiceDate(invoiceDocument.getInvoiceDate()).invoiceDueDate(invoiceDocument.getInvoiceDueDate()).termOfPaymentDays(invoiceDocument.getTermOfPaymentDays()).invoiceNr(invoiceDocument.getInvoiceNr()).title(invoiceDocument.getTitle()).prefaceText(invoiceDocument.getPrefaceText()).endingText(invoiceDocument.getEndingText()).positions(this.map(invoiceDocument.getPositions())).currency(Currency.getInstance(invoiceDocument.getCurrency().name())).sender(s -> s.addressLines(this.map(invoiceDocument.getSender())).build()).recipient(r -> r.addressLines(this.map(invoiceDocument.getRecipient())).build()).additionalProperties(this.mapAdditionalProperties(invoiceDocument.getAdditionalProperties())).contactPerson(cp -> {
            if (invoiceDocument.getContactPerson() != null) {
                cp.name(invoiceDocument.getContactPerson().getName());
                cp.email(invoiceDocument.getContactPerson().getEmail());
                cp.phoneNr(invoiceDocument.getContactPerson().getPhoneNr());
            }
            cp.build();
        }).qrInvoice(InboundModelMapper.create((boolean)this.normalizeString).map(invoiceDocument.getQrInvoice())).build();
    }

    private String[] map(Address address) {
        if (address == null || address.getAddressLines() == null) {
            return null;
        }
        return address.getAddressLines();
    }

    private List<ch.codeblock.qrinvoice.documents.model.application.Position> map(Position[] positions) {
        if (positions == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(positions).map((? super T position) -> PositionBuilder.create().position(position.getPosition()).description(position.getDescription()).quantity(position.getQuantity()).unitPrice(this.mapUnitPrice(position)).unit(position.getUnit()).discountAbsolute(this.mapDiscountAbsolute(position)).discountPercentage(Percentage.ofNumericalPercentage((BigDecimal)position.getDiscountPercentage())).additionalProperties(this.mapAdditionalProperties(position.getAdditionalProperties())).build()).collect(Collectors.toList());
    }

    private Amount mapUnitPrice(Position position) {
        if (position.getUnitPrice() == null) {
            return null;
        }
        return AmountBuilder.create().vatExclusive(position.getUnitPrice().getVatExclusive()).vatInclusive(position.getUnitPrice().getVatInclusive()).vatPercentage(this.mapVatPercentage(position.getUnitPrice().getVatPercentage())).build();
    }

    private Amount mapDiscountAbsolute(Position position) {
        if (position.getDiscountAbsolute() == null) {
            return null;
        }
        return AmountBuilder.create().vatExclusive(position.getDiscountAbsolute().getVatExclusive()).vatInclusive(position.getDiscountAbsolute().getVatInclusive()).vatPercentage(this.mapVatPercentage(position.getDiscountAbsolute().getVatPercentage())).build();
    }

    private Percentage mapVatPercentage(BigDecimal vatPercentage) {
        return vatPercentage != null ? Percentage.ofNumericalPercentage((BigDecimal)vatPercentage) : null;
    }

    private List<ch.codeblock.qrinvoice.documents.model.application.AdditionalProperty> mapAdditionalProperties(AdditionalProperty[] additionalProperties) {
        if (additionalProperties == null) {
            return Collections.emptyList();
        }
        return Stream.of(additionalProperties).map((? super T additionalProperty) -> new ch.codeblock.qrinvoice.documents.model.application.AdditionalProperty(additionalProperty.getKey(), additionalProperty.getValue())).collect(Collectors.toList());
    }
}

