/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model;

import ch.codeblock.qrinvoice.documents.model.application.Percentage;
import ch.codeblock.qrinvoice.rest.model.CurrencyEnum;
import ch.codeblock.qrinvoice.rest.model.OutboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.documents.AdditionalProperty;
import ch.codeblock.qrinvoice.rest.model.documents.Address;
import ch.codeblock.qrinvoice.rest.model.documents.Amount;
import ch.codeblock.qrinvoice.rest.model.documents.ContactPerson;
import ch.codeblock.qrinvoice.rest.model.documents.InvoiceDocument;
import ch.codeblock.qrinvoice.rest.model.documents.Position;
import ch.codeblock.qrinvoice.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.List;

public class InvoiceDocumentOutboundModelMapper {
    public static InvoiceDocumentOutboundModelMapper create() {
        return new InvoiceDocumentOutboundModelMapper();
    }

    public InvoiceDocument map(ch.codeblock.qrinvoice.documents.model.application.InvoiceDocument invoiceDocument) {
        InvoiceDocument result = new InvoiceDocument();
        result.setSender(this.map(invoiceDocument.getSender()));
        result.setRecipient(this.map(invoiceDocument.getRecipient()));
        result.setContactPerson(this.map(invoiceDocument.getContactPerson()));
        result.setCustomerNr(invoiceDocument.getCustomerNr());
        result.setCustomerReference(invoiceDocument.getCustomerReference());
        result.setInvoiceDate(invoiceDocument.getInvoiceDate());
        result.setInvoiceDueDate(invoiceDocument.getInvoiceDueDate());
        result.setTermOfPaymentDays(invoiceDocument.getTermOfPaymentDays());
        result.setInvoiceNr(invoiceDocument.getInvoiceNr());
        result.setTitle(invoiceDocument.getTitle());
        result.setPrefaceText(invoiceDocument.getPrefaceText());
        result.setEndingText(invoiceDocument.getEndingText());
        result.setPositions(this.mapPositions(invoiceDocument.getPositions()));
        result.setCurrency(this.map(invoiceDocument.getCurrency()));
        result.setAdditionalProperties(this.mapAdditionalProperties(invoiceDocument.getAdditionalProperties()));
        result.setQrInvoice(OutboundModelMapper.create().map(invoiceDocument.getQrInvoice()));
        result.getQrInvoice().getPaymentAmountInformation().setAmount(null);
        return result;
    }

    private Position[] mapPositions(List<ch.codeblock.qrinvoice.documents.model.application.Position> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return new Position[0];
        }
        return (Position[])positions.stream().map((? super T position) -> {
            Position p = new Position();
            p.setPosition(position.getPosition());
            p.setDescription(position.getDescription());
            p.setQuantity(position.getQuantity());
            p.setUnitPrice(this.mapAmount(position.getUnitPrice()));
            p.setUnit(position.getUnit());
            p.setDiscountAbsolute(this.mapAmount(position.getDiscountAbsolute()));
            p.setDiscountPercentage(this.map(position.getDiscountPercentage()));
            p.setAdditionalProperties(this.mapAdditionalProperties(position.getAdditionalProperties()));
            return p;
        }).toArray(Position[]::new);
    }

    private AdditionalProperty[] mapAdditionalProperties(List<ch.codeblock.qrinvoice.documents.model.application.AdditionalProperty> additionalProperties) {
        if (CollectionUtils.isEmpty(additionalProperties)) {
            return new AdditionalProperty[0];
        }
        return (AdditionalProperty[])additionalProperties.stream().map((? super T additionalProperty) -> {
            AdditionalProperty ap = new AdditionalProperty();
            ap.setKey(additionalProperty.getKey());
            ap.setValue(additionalProperty.getValue());
            return ap;
        }).toArray(AdditionalProperty[]::new);
    }

    private Amount mapAmount(ch.codeblock.qrinvoice.documents.model.application.Amount amount) {
        if (amount == null) {
            return null;
        }
        Amount result = new Amount();
        if (amount.preferVatExclusive()) {
            result.setVatExclusive(amount.getVatExclusive());
        } else {
            result.setVatInclusive(amount.getVatInclusive());
        }
        result.setVatPercentage(this.map(amount.getVatPercentage()));
        return result;
    }

    private BigDecimal map(Percentage percentage) {
        if (percentage == null) {
            return null;
        }
        return percentage.getNumericalPercentageValue();
    }

    private CurrencyEnum map(Currency currency) {
        if (currency == null) {
            return null;
        }
        return CurrencyEnum.fromValue((String)currency.getCurrencyCode());
    }

    private ContactPerson map(ch.codeblock.qrinvoice.documents.model.application.ContactPerson contactPerson) {
        if (contactPerson == null) {
            return null;
        }
        ContactPerson result = new ContactPerson();
        result.setName(contactPerson.getName());
        result.setEmail(contactPerson.getEmail());
        result.setPhoneNr(contactPerson.getPhoneNr());
        return result;
    }

    private Address map(ch.codeblock.qrinvoice.documents.model.application.Address address) {
        if (address == null) {
            return null;
        }
        Address result = new Address();
        if (address.getAddressLines() != null) {
            result.setAddressLines(address.getAddressLines().toArray(new String[0]));
        }
        return result;
    }
}

