/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model;

import ch.codeblock.qrinvoice.model.billinformation.RawBillInformation;
import ch.codeblock.qrinvoice.model.billinformation.swicos1v12.SwicoS1v12;
import ch.codeblock.qrinvoice.rest.model.AdditionalInformation;
import ch.codeblock.qrinvoice.rest.model.AddressTypeEnum;
import ch.codeblock.qrinvoice.rest.model.AlternativeSchemes;
import ch.codeblock.qrinvoice.rest.model.Creditor;
import ch.codeblock.qrinvoice.rest.model.CreditorInformation;
import ch.codeblock.qrinvoice.rest.model.CurrencyEnum;
import ch.codeblock.qrinvoice.rest.model.OutboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.PaymentAmountInformation;
import ch.codeblock.qrinvoice.rest.model.PaymentReference;
import ch.codeblock.qrinvoice.rest.model.QrInvoice;
import ch.codeblock.qrinvoice.rest.model.ReferenceTypeEnum;
import ch.codeblock.qrinvoice.rest.model.UltimateCreditor;
import ch.codeblock.qrinvoice.rest.model.UltimateDebtor;
import ch.codeblock.qrinvoice.rest.model.billinformation.BillInformation;
import ch.codeblock.qrinvoice.rest.model.billinformation.RawOutboundModelMapper;
import ch.codeblock.qrinvoice.rest.model.billinformation.swicos1v12.S1OutboundModelMapper;

public class OutboundModelMapper {
    public static OutboundModelMapper create() {
        return new OutboundModelMapper();
    }

    public QrInvoice map(ch.codeblock.qrinvoice.model.QrInvoice qrInvoice) {
        return this.map(qrInvoice, false);
    }

    public QrInvoice map(ch.codeblock.qrinvoice.model.QrInvoice qrInvoice, boolean expandBillInformation) {
        if (qrInvoice == null) {
            return null;
        }
        QrInvoice result = new QrInvoice();
        result.setCreditorInformation(this.mapCreditorInformation(qrInvoice.getCreditorInformation()));
        result.setUltimateCreditor(this.mapUltimateCreditor(qrInvoice.getUltimateCreditor()));
        result.setUltimateDebtor(this.mapUltimateDebtor(qrInvoice.getUltimateDebtor()));
        result.setPaymentReference(this.mapPaymentReference(qrInvoice.getPaymentReference(), expandBillInformation));
        result.setPaymentAmountInformation(this.mapPaymentAmountInformation(qrInvoice.getPaymentAmountInformation()));
        result.setAlternativeSchemes(this.mapAlternativeSchemes(qrInvoice.getAlternativeSchemes()));
        return result;
    }

    private CreditorInformation mapCreditorInformation(ch.codeblock.qrinvoice.model.CreditorInformation creditorInformation) {
        if (creditorInformation == null) {
            return null;
        }
        CreditorInformation result = new CreditorInformation();
        result.setIban(creditorInformation.getIban());
        result.setCreditor(this.mapCreditor(creditorInformation.getCreditor()));
        return result;
    }

    private Creditor mapCreditor(ch.codeblock.qrinvoice.model.Creditor creditor) {
        if (creditor == null) {
            return null;
        }
        Creditor result = new Creditor();
        result.setName(creditor.getName());
        switch (1.$SwitchMap$ch$codeblock$qrinvoice$model$AddressType[creditor.getAddressType().ordinal()]) {
            case 1: {
                result.setAddressType(AddressTypeEnum.STRUCTURED);
                result.setStreetName(creditor.getStreetName());
                result.setHouseNumber(creditor.getHouseNumber());
                result.setPostalCode(creditor.getPostalCode());
                result.setCity(creditor.getCity());
                break;
            }
            case 2: {
                result.setAddressType(AddressTypeEnum.COMBINED);
                result.setAddressLine1(creditor.getAddressLine1());
                result.setAddressLine2(creditor.getAddressLine2());
            }
        }
        result.setCountry(creditor.getCountry());
        return result;
    }

    private UltimateCreditor mapUltimateCreditor(ch.codeblock.qrinvoice.model.UltimateCreditor ultimateCreditor) {
        if (ultimateCreditor == null) {
            return null;
        }
        UltimateCreditor result = new UltimateCreditor();
        result.setName(ultimateCreditor.getName());
        switch (1.$SwitchMap$ch$codeblock$qrinvoice$model$AddressType[ultimateCreditor.getAddressType().ordinal()]) {
            case 1: {
                result.setAddressType(AddressTypeEnum.STRUCTURED);
                result.setStreetName(ultimateCreditor.getStreetName());
                result.setHouseNumber(ultimateCreditor.getHouseNumber());
                result.setPostalCode(ultimateCreditor.getPostalCode());
                result.setCity(ultimateCreditor.getCity());
                break;
            }
            case 2: {
                result.setAddressType(AddressTypeEnum.COMBINED);
                result.setAddressLine1(ultimateCreditor.getAddressLine1());
                result.setAddressLine2(ultimateCreditor.getAddressLine2());
            }
        }
        result.setCountry(ultimateCreditor.getCountry());
        return result;
    }

    private UltimateDebtor mapUltimateDebtor(ch.codeblock.qrinvoice.model.UltimateDebtor ultimateDebtor) {
        if (ultimateDebtor == null) {
            return null;
        }
        UltimateDebtor result = new UltimateDebtor();
        result.setName(ultimateDebtor.getName());
        switch (1.$SwitchMap$ch$codeblock$qrinvoice$model$AddressType[ultimateDebtor.getAddressType().ordinal()]) {
            case 1: {
                result.setAddressType(AddressTypeEnum.STRUCTURED);
                result.setStreetName(ultimateDebtor.getStreetName());
                result.setHouseNumber(ultimateDebtor.getHouseNumber());
                result.setPostalCode(ultimateDebtor.getPostalCode());
                result.setCity(ultimateDebtor.getCity());
                break;
            }
            case 2: {
                result.setAddressType(AddressTypeEnum.COMBINED);
                result.setAddressLine1(ultimateDebtor.getAddressLine1());
                result.setAddressLine2(ultimateDebtor.getAddressLine2());
            }
        }
        result.setCountry(ultimateDebtor.getCountry());
        return result;
    }

    private PaymentReference mapPaymentReference(ch.codeblock.qrinvoice.model.PaymentReference paymentReference, boolean expandBillInformation) {
        if (paymentReference == null) {
            return null;
        }
        PaymentReference result = new PaymentReference();
        result.setReferenceType(ReferenceTypeEnum.valueOf((String)paymentReference.getReferenceType().name()));
        result.setReference(paymentReference.getReference());
        result.setAdditionalInformation(this.mapAdditionalInformation(paymentReference.getAdditionalInformation(), expandBillInformation));
        return result;
    }

    private AdditionalInformation mapAdditionalInformation(ch.codeblock.qrinvoice.model.AdditionalInformation additionalInformation, boolean expandBillInformation) {
        if (additionalInformation == null) {
            return null;
        }
        AdditionalInformation result = new AdditionalInformation();
        result.setBillInformation(additionalInformation.getBillInformation());
        if (expandBillInformation) {
            if (additionalInformation.getBillInformationObject() instanceof SwicoS1v12) {
                result.setBillInformationObject((BillInformation)new S1OutboundModelMapper().map((SwicoS1v12)additionalInformation.getBillInformationObject()));
            } else if (additionalInformation.getBillInformationObject() instanceof RawBillInformation) {
                result.setBillInformationObject((BillInformation)new RawOutboundModelMapper().map((RawBillInformation)additionalInformation.getBillInformationObject()));
            }
        }
        result.setUnstructuredMessage(additionalInformation.getUnstructuredMessage());
        return result;
    }

    private PaymentAmountInformation mapPaymentAmountInformation(ch.codeblock.qrinvoice.model.PaymentAmountInformation paymentAmountInformation) {
        if (paymentAmountInformation == null) {
            return null;
        }
        PaymentAmountInformation result = new PaymentAmountInformation();
        result.setAmount(paymentAmountInformation.getAmount());
        result.setCurrency(CurrencyEnum.fromValue((String)paymentAmountInformation.getCurrency().getCurrencyCode()));
        return result;
    }

    private AlternativeSchemes mapAlternativeSchemes(ch.codeblock.qrinvoice.model.AlternativeSchemes alternativeSchemes) {
        if (alternativeSchemes == null) {
            return null;
        }
        if (alternativeSchemes.getAlternativeSchemeParameters() != null) {
            AlternativeSchemes result = new AlternativeSchemes();
            result.setAlternativeSchemeParameters(alternativeSchemes.getAlternativeSchemeParameters().toArray(new String[0]));
            return result;
        }
        return null;
    }
}

