/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.model.security;

import ch.codeblock.qrinvoice.rest.model.security.ApiKey;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyReader;
import ch.codeblock.qrinvoice.rest.model.security.ApiKeyWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyRegistry {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyRegistry.class);
    @Value(value="${qrinvoice.apikey.path}")
    private String apiKeyPath;
    @Value(value="${qrinvoice.apikey.enabled}")
    private String apiKeyEnabled;
    private ApiKey[] apiKeys;

    @PostConstruct
    public void init() {
        this.init(Boolean.parseBoolean(this.apiKeyEnabled), this.apiKeyPath);
    }

    void init(boolean apiKeyEnabled, String apiKeyPath) {
        if (apiKeyEnabled) {
            try {
                this.apiKeys = new ApiKeyReader().readFromFile(apiKeyPath);
            }
            catch (IOException e) {
                this.logger.error("Error during read of API Key file from apiKeyPath={}", (Object)apiKeyPath, (Object)e);
                this.apiKeys = new ApiKey[0];
            }
        }
    }

    public ApiKey[] getApiKeys() {
        return this.apiKeys;
    }

    public synchronized void reloadApiKeyFile() throws IOException {
        this.logger.info("Reloading API Keys from {}", (Object)this.apiKeyPath);
        ApiKey[] newLoadedApiKeys = new ApiKeyReader().readFromFile(this.apiKeyPath);
        this.switchKeys(newLoadedApiKeys);
    }

    private synchronized boolean switchKeys(ApiKey[] newLoadedApiKeys) {
        if (newLoadedApiKeys == null || newLoadedApiKeys.length == 0) {
            this.logger.warn("Reloading API Keys ignored as it was empty");
        } else if (newLoadedApiKeys.length < this.apiKeys.length - 10) {
            this.logger.warn("Reloading API Keys ignored as more than 10 API Keys would have been deleted");
        } else if (CollectionUtils.containsAll(Arrays.asList(this.apiKeys), Arrays.asList(newLoadedApiKeys))) {
            this.logger.info("Reloading API Keys ignored as keys were unchanged");
        } else {
            this.logger.info("Reloading API Keys");
            this.apiKeys = newLoadedApiKeys;
            return true;
        }
        return false;
    }

    public Optional<ApiKey> getApiKey(String apiKey) {
        if (this.apiKeys != null) {
            for (ApiKey key : this.apiKeys) {
                if (!key.getApiKey().equals(apiKey)) continue;
                return Optional.of(key);
            }
        }
        return Optional.empty();
    }

    public synchronized void updateKeys(ApiKey[] newLoadedApiKeys) throws IOException {
        if (this.switchKeys(newLoadedApiKeys)) {
            new ApiKeyWriter().writeToFile(this.apiKeyPath, newLoadedApiKeys);
        }
    }
}

