/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoice.rest.resources;

import ch.codeblock.qrinvoice.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CustomerResourcesRepository {
    private Path customerResources;

    public CustomerResourcesRepository(@Value(value="${qrinvoice.customer.resources.path}") String customerResourcesPath) {
        this.customerResources = Paths.get(customerResourcesPath, new String[0]);
    }

    public Path getCustomerDir(Integer customerId) throws IOException {
        String customerIdString = customerId != null ? customerId.toString() : "default";
        Path customerDir = this.customerResources.resolve(customerIdString);
        Files.createDirectories(customerDir, new FileAttribute[0]);
        return customerDir;
    }

    public Optional<Path> getFile(Integer customerId, String filename) throws IOException {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return Optional.empty();
        }
        Path customerDir = this.getCustomerDir(customerId);
        Path resourceFile = customerDir.resolve(filename);
        if (Files.exists(resourceFile, new LinkOption[0])) {
            return Optional.of(resourceFile);
        }
        return Optional.empty();
    }

    public Path writeFile(Integer customerId, String filename, InputStream inputStream) throws IOException {
        Path customerDir = this.getCustomerDir(customerId);
        Path resourceFile = customerDir.resolve(filename);
        Files.copy(inputStream, resourceFile, new CopyOption[0]);
        return resourceFile;
    }
}

