/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoiceweb.config;

import ch.codeblock.qrinvoiceweb.config.ApplicationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.web.filter.CorsFilter;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final CorsFilter corsFilter;
    private final ApplicationProperties applicationProperties;

    public SecurityConfiguration(CorsFilter corsFilter, ApplicationProperties applicationProperties) {
        this.corsFilter = corsFilter;
        this.applicationProperties = applicationProperties;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/rest/**"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        String restDomain = this.applicationProperties.getQrinvoiceRestBackendUrl();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).headers().contentSecurityPolicy("default-src 'self' " + restDomain + "; frame-src 'self' data: " + restDomain + "; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).authenticated().and()).httpBasic();
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowBackSlash(true);
        return web -> web.httpFirewall((HttpFirewall)firewall);
    }
}

