/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoiceweb.aop.logging;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Aspect
public class LoggingAspect {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Environment env;

    public LoggingAspect(Environment env) {
        this.env = env;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public void springBeanPointcut() {
    }

    @Pointcut(value="within(ch.codeblock.qrinvoiceweb.repository..*) || within(ch.codeblock.qrinvoiceweb.service..*) || within(ch.codeblock.qrinvoiceweb.web.rest..*)")
    public void applicationPackagePointcut() {
    }

    @AfterThrowing(pointcut="applicationPackagePointcut() && springBeanPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            this.log.error("Exception in {}.{}() with cause = '{}' and exception = '{}'", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL", e.getMessage(), e});
        } else {
            this.log.error("Exception in {}.{}() with cause = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL"});
        }
    }

    @Around(value="applicationPackagePointcut() && springBeanPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Enter: {}.{}() with argument[s] = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), Arrays.toString(joinPoint.getArgs())});
        }
        try {
            Object result = joinPoint.proceed();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exit: {}.{}() with result = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), result});
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            this.log.error("Illegal argument: {} in {}.{}()", new Object[]{Arrays.toString(joinPoint.getArgs()), joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
            throw e;
        }
    }
}

