/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoiceweb.config;

import io.github.jhipster.config.h2.H2ConfigurationHelper;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(value={"ch.codeblock.qrinvoiceweb.repository"})
@EnableJpaAuditing(auditorAwareRef="springSecurityAuditorAware")
@EnableTransactionManagement
public class DatabaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private final Environment env;

    public DatabaseConfiguration(Environment env) {
        this.env = env;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @Profile(value={"dev"})
    public Object h2TCPServer() throws SQLException {
        String port = this.getValidPortForH2();
        this.log.debug("H2 database is available on port {}", (Object)port);
        return H2ConfigurationHelper.createServer((String)port);
    }

    private String getValidPortForH2() {
        int port = Integer.parseInt(this.env.getProperty("server.port"));
        port = port < 10000 ? 10000 + port : (port < 63536 ? (port += 2000) : (port -= 2000));
        return String.valueOf(port);
    }
}

