/*
 * Decompiled with CFR 0.152.
 */
package ch.codeblock.qrinvoiceweb.web.rest;

import ch.codeblock.qrinvoiceweb.domain.User;
import ch.codeblock.qrinvoiceweb.repository.UserRepository;
import ch.codeblock.qrinvoiceweb.security.SecurityUtils;
import ch.codeblock.qrinvoiceweb.service.MailService;
import ch.codeblock.qrinvoiceweb.service.UserService;
import ch.codeblock.qrinvoiceweb.service.dto.PasswordChangeDTO;
import ch.codeblock.qrinvoiceweb.service.dto.UserDTO;
import ch.codeblock.qrinvoiceweb.web.rest.AccountResource;
import ch.codeblock.qrinvoiceweb.web.rest.errors.EmailAlreadyUsedException;
import ch.codeblock.qrinvoiceweb.web.rest.errors.EmailNotFoundException;
import ch.codeblock.qrinvoiceweb.web.rest.errors.InvalidPasswordException;
import ch.codeblock.qrinvoiceweb.web.rest.vm.KeyAndPasswordVM;
import ch.codeblock.qrinvoiceweb.web.rest.vm.ManagedUserVM;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api"})
public class AccountResource {
    private final Logger log = LoggerFactory.getLogger(AccountResource.class);
    private final UserRepository userRepository;
    private final UserService userService;
    private final MailService mailService;

    public AccountResource(UserRepository userRepository, UserService userService, MailService mailService) {
        this.userRepository = userRepository;
        this.userService = userService;
        this.mailService = mailService;
    }

    @PostMapping(value={"/register"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void registerAccount(@Valid @RequestBody ManagedUserVM managedUserVM) {
        if (!AccountResource.checkPasswordLength((String)managedUserVM.getPassword())) {
            throw new InvalidPasswordException();
        }
        User user = this.userService.registerUser((UserDTO)managedUserVM, managedUserVM.getPassword());
        this.mailService.sendActivationEmail(user);
    }

    @GetMapping(value={"/activate"})
    public void activateAccount(@RequestParam(value="key") String key) {
        Optional user = this.userService.activateRegistration(key);
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this activation key", null);
        }
    }

    @GetMapping(value={"/authenticate"})
    public String isAuthenticated(HttpServletRequest request) {
        this.log.debug("REST request to check if the current user is authenticated");
        return request.getRemoteUser();
    }

    @GetMapping(value={"/account"})
    public UserDTO getAccount() {
        return this.userService.getUserWithAuthorities().map(UserDTO::new).orElseThrow(() -> new AccountResourceException("User could not be found", null));
    }

    @PostMapping(value={"/account"})
    public void saveAccount(@Valid @RequestBody UserDTO userDTO) {
        String userLogin = (String)SecurityUtils.getCurrentUserLogin().orElseThrow(() -> new AccountResourceException("Current user login not found", null));
        Optional existingUser = this.userRepository.findOneByEmailIgnoreCase(userDTO.getEmail());
        if (existingUser.isPresent() && !((User)existingUser.get()).getLogin().equalsIgnoreCase(userLogin)) {
            throw new EmailAlreadyUsedException();
        }
        Optional user = this.userRepository.findOneByLogin(userLogin);
        if (!user.isPresent()) {
            throw new AccountResourceException("User could not be found", null);
        }
        this.userService.updateUser(userDTO.getFirstName(), userDTO.getLastName(), userDTO.getEmail(), userDTO.getLangKey(), userDTO.getImageUrl());
    }

    @PostMapping(path={"/account/change-password"})
    public void changePassword(@RequestBody PasswordChangeDTO passwordChangeDto) {
        if (!AccountResource.checkPasswordLength((String)passwordChangeDto.getNewPassword())) {
            throw new InvalidPasswordException();
        }
        this.userService.changePassword(passwordChangeDto.getCurrentPassword(), passwordChangeDto.getNewPassword());
    }

    @PostMapping(path={"/account/reset-password/init"})
    public void requestPasswordReset(@RequestBody String mail) {
        this.mailService.sendPasswordResetMail((User)this.userService.requestPasswordReset(mail).orElseThrow(EmailNotFoundException::new));
    }

    @PostMapping(path={"/account/reset-password/finish"})
    public void finishPasswordReset(@RequestBody KeyAndPasswordVM keyAndPassword) {
        if (!AccountResource.checkPasswordLength((String)keyAndPassword.getNewPassword())) {
            throw new InvalidPasswordException();
        }
        Optional user = this.userService.completePasswordReset(keyAndPassword.getNewPassword(), keyAndPassword.getKey());
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this reset key", null);
        }
    }

    private static boolean checkPasswordLength(String password) {
        return !StringUtils.isEmpty((CharSequence)password) && password.length() >= 4 && password.length() <= 100;
    }
}

